package api

import (
	"net/http"

	"code.justin.tv/insights/piper-service/models"

	"goji.io/pat"
	"golang.org/x/net/context"
)

func (s *Server) GetMods(ctx context.Context, r *http.Request) (interface{}, error) {
	userID := betterformat(pat.Param(r, "user_id"))

	trackingEvent := models.SpadeEvent{
		UserID:       userID,
		ClientID:     r.Header.Get("Twitch-Client-ID"),
		IsFirstParty: true,
		Action:       "get_mod_reports",
		IfSucceed:    false,
	}
	modReports, err := s.getModReports(ctx, userID)
	s.reportTracking(ctx, trackingEvent, trackingModsBackend, err)

	return modReports, err
}

func (s *Server) getModReports(ctx context.Context, userID string) (interface{}, error) {
	result, err := s.modsBackend.GetModReports(ctx, userID, s.piperConfig)

	if err != nil {
		return nil, err
	}

	return &models.ReportsResp{Key: *result}, nil
}

func (s *Server) GetModReportLatest(ctx context.Context, r *http.Request) (interface{}, error) {
	userID := betterformat(pat.Param(r, "user_id"))
	modID := betterformat(pat.Param(r, "mod_id"))
	reportType := betterformat(pat.Param(r, "report_type"))

	trackingEvent := models.SpadeEvent{
		UserID:       userID,
		DomainID:     modID,
		ReportID:     reportType,
		ClientID:     r.Header.Get("Twitch-Client-ID"),
		IsFirstParty: true,
		Action:       "get_mod_report_download_url",
		IfSucceed:    false,
	}

	url, err := s.getModsLatestPreSignedURL(ctx, userID, modID, reportType)
	s.reportTracking(ctx, trackingEvent, trackingModsBackend, err)

	return url, err
}

func (s *Server) getModsLatestPreSignedURL(ctx context.Context, userID, modID, reportType string) (interface{}, error) {
	preSigned, err := s.modsBackend.GetModReportURL(ctx, userID, modID, reportType, s.piperConfig)
	if err != nil {
		return "", err
	}

	return wrapResults("url", preSigned), nil
}
