package api

import (
	"net/http"

	"golang.org/x/net/context"

	"code.justin.tv/chat/golibs/logx"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/insights/piper-service/models"
)

type wrapFunc func(context.Context, *http.Request) (interface{}, error)

// createhandler is a handler wrapper that returns handler function
// It will get context, run handler function, serve error if there is any,
// set http status code, and serve result to json object
func createhandler(handler wrapFunc) func(w http.ResponseWriter, r *http.Request) {
	return func(w http.ResponseWriter, r *http.Request) {
		defer logx.RecoverAndLog()

		ctx := logx.WithFields(r.Context(), logx.Fields{
			"method":            r.Method,
			"ip":                getIPFromRequest(r),
			"url":               r.URL.Path,
			"repository_source": getTwitchRepositoryFromRequest(r),
			"client_id":         r.Header.Get("Twitch-Client-ID"),
		})

		response, err := handler(ctx, r)
		if err != nil {
			status := reportError(ctx, err)
			serveJSON(ctx, status, w, models.NewErrorResponse(status, errx.Cause(err)))
			return
		}

		if response == nil {
			w.WriteHeader(http.StatusNoContent)
			return
		}

		serveJSON(ctx, 200, w, response)
	}
}
