package drops

import (
	"code.justin.tv/common/spade-client-go/spade"
	"code.justin.tv/insights/piper-service/backend"
	"code.justin.tv/insights/piper-service/backend/s3report"
	"code.justin.tv/insights/piper-service/internal/clients/piperdb"
	"code.justin.tv/insights/piper-service/internal/clients/rbac"
	"code.justin.tv/insights/piper-service/internal/clients/s3"
	"code.justin.tv/insights/piper-service/internal/clients/users"
	"code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

//go:generate mockery -name Backend
type Backend interface {
	GetDropReportURL(ctx context.Context, userID string, resourceID string, reportType string, orgID string, config config.PiperConfig) (string, error)
	UserCanAccess(ctx context.Context, userID string, reportType string, orgID string) (bool, error)
	TrackDropsReportUsage(ctx context.Context, trackingEvent models.SpadeEvent)
}

type dropsImpl struct {
	s3       s3.Client
	spade    spade.Client
	piperdb  piperdb.Client
	rbac     rbac.Client
	users    users.Client
	s3report s3report.Backend
	cacher   backend.Cacher
}

func NewBackend(s3Client s3.Client, spadeClient spade.Client, piperdbClient piperdb.Client, rbacClient rbac.Client, usersClient users.Client, s3report s3report.Backend, cacher backend.Cacher) (Backend, error) {
	return &dropsImpl{
		s3:       s3Client,
		spade:    spadeClient,
		piperdb:  piperdbClient,
		rbac:     rbacClient,
		users:    usersClient,
		s3report: s3report,
		cacher:   cacher,
	}, nil
}

const (
	dropsCampaignOverview     = "campaigns_overview"
	dropsCampaignDropOverview = "campaigns_drops_overview"
	dropsCampaignTopStreamers = "campaigns_top_streamers"
	domain                    = "drops"
	urlExpireMinutes          = 5
)
