package drops

import (
	"code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/lib/reports"
	"golang.org/x/net/context"
)

func (c *dropsImpl) GetDropReportURL(ctx context.Context, userID string, resourceID string, reportType string, orgID string, conf config.PiperConfig) (string, error) {
	// determine access rights
	_, err := c.UserCanAccess(ctx, userID, reportType, orgID)
	if err != nil {
		return "", err
	}

	// determine domain report date range
	startDate, endDate, err := c.GetFittedDateRange(ctx, resourceID, reportType, "", "")
	if err != nil {
		return "", err
	}

	// generate and return report URL
	return c.generateReportURL(ctx, userID, resourceID, reportType, startDate, endDate, conf)
}

func (c *dropsImpl) GetFittedDateRange(ctx context.Context, resourceID, reportType, startDate, endDate string) (string, string, error) {
	dbStartDate, dbEndDate, err := c.piperdb.GetDomainReportDateRange(ctx, domain, reportType, resourceID)
	if err != nil {
		return "", "", err
	}
	return reports.GetFittedDateRange(startDate, endDate, dbStartDate, dbEndDate)
}

// TODO: add resource name
func (c *dropsImpl) generateReportURL(ctx context.Context, userID, resourceID, reportType, startDate, endDate string, conf config.PiperConfig) (string, error) {
	// retrieve report from Piper
	report, err := c.piperdb.GetDropsReportByDate(ctx, resourceID, reportType, startDate, endDate)
	if err != nil {
		return "", err
	}

	// put report in S3
	fileName, err := c.s3report.SaveReportToS3(ctx, report, resourceID, reportType, startDate, endDate, conf.ReportBucket, conf.DynamicReportPrefix)
	if err != nil {
		return "", err
	}

	path := conf.DynamicReportPrefix + fileName
	presignedName := reports.GetFileNameNoUUID(fileName)

	// returns presigned URL to report in S3 bucket
	// link expires in 5 minutes
	return c.s3.PreSignURL(conf.ReportBucket, path, presignedName, urlExpireMinutes)
}
