package extensions

import (
	"code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/lib/reports"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

func (c *extensionsRepoImpl) GetReportTypes(ctx context.Context, userID string, extensionID string, config config.PiperConfig) (*models.ReportType, error) {
	extensionReportType := models.ReportType{ID: extensionID, ReportTypes: []string{}}

	// prefilter report type for dev site integration
	reportType := reports.DevsiteExtensionsReportType

	extensionIDs, err := c.piperdbclient.GetAvailableDomainsWithReports(ctx, backendDomain, reportType, []string{extensionID})
	if err != nil || len(extensionIDs) == 0 {
		return nil, models.ErrResourceNotFound
	}

	if len(extensionIDs) > 0 {
		extensionReportType.ReportTypes = []string{reportType}
	}

	return &extensionReportType, nil
}
