package extensions

import (
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/lib/reports"
	"golang.org/x/net/context"
)

func (c *extensionsRepoImpl) GetReportByDate(ctx context.Context, extensionID, reportType, startDate, endDate string, conf config.PiperConfig) (string, error) {

	startDate, endDate, err := c.GetFittedDateRange(ctx, extensionID, reportType, startDate, endDate)
	if err != nil {
		return "", errx.New(err)
	}

	return c.generateReportURL(ctx, "", extensionID, reportType, startDate, endDate, conf)
}

func (c *extensionsRepoImpl) GetFittedDateRange(ctx context.Context, extensionID, reportType, startDate, endDate string) (string, string, error) {
	dbStartDate, dbEndDate, err := c.piperdbclient.GetDomainReportDateRange(ctx, backendDomain, reportType, extensionID)
	if err != nil || dbStartDate.IsZero() || dbEndDate.IsZero() {
		return "", "", err
	}

	return reports.GetFittedDateRange(startDate, endDate, dbStartDate, dbEndDate)
}

func (c *extensionsRepoImpl) generateReportURL(ctx context.Context, userID, extensionID, reportType, startDate, endDate string, conf config.PiperConfig) (string, error) {
	extensionName := c.owl.GetExtensionName(ctx, extensionID)

	report, err := c.piperdbclient.GetExtensionReportByDate(ctx, extensionID, reportType, startDate, endDate)
	if err != nil {
		return "", errx.New(err)
	}

	fileName, err := c.s3report.SaveReportToS3(ctx, report, extensionName, reportType, startDate, endDate, conf.ReportBucket, conf.DynamicReportPrefix)
	if err != nil {
		return "", errx.New(err)
	}

	path := conf.DynamicReportPrefix + fileName
	presignedName := reports.GetFileNameNoUUID(fileName)

	return c.s3.PreSignURL(conf.ReportBucket, path, presignedName, urlExpireMinutes)
}
