package extensions

import (
	"fmt"

	"time"

	"code.justin.tv/chat/golibs/logx"
	"code.justin.tv/insights/piper-service/models"
	"code.justin.tv/web/users-service/client"
	"golang.org/x/net/context"
)

func (c *extensionsRepoImpl) TrackExtensionReportUsage(ctx context.Context, extensionsEvent models.SpadeEvent) {
	go func() {
		copiedCtx := logx.CopyFields(ctx, context.Background())
		if extensionsEvent.DomainID != "" {
			owlCtx, _ := context.WithTimeout(copiedCtx, 5*time.Second)
			extensionsEvent.DomainName = c.owl.GetExtensionName(owlCtx, extensionsEvent.DomainID)
		}

		usersCtx, _ := context.WithTimeout(copiedCtx, 5*time.Second)
		isStaff, err := c.users.IsStaff(usersCtx, extensionsEvent.UserID)
		if err != nil {
			if _, ok := err.(*client.UserNotFoundError); !ok {
				logx.Error(usersCtx, fmt.Sprintf("failed to get staff status for user %s: %v", extensionsEvent.UserID, err), logx.Fields{
					"extension_id": extensionsEvent.DomainID,
				})
			}
			isStaff = false
		}
		extensionsEvent.IsStaff = isStaff

		bCtx, _ := context.WithTimeout(copiedCtx, 5*time.Second)
		if extensionsEvent.StartDateStr != "" {
			time, err := time.Parse(time.RFC3339, extensionsEvent.StartDateStr)
			if err != nil {
				logx.Warn(bCtx, fmt.Sprintf("failed to parse start date while reporting to spade %s: %v", extensionsEvent.StartDateStr, err))
			}
			extensionsEvent.StartDate = float64(time.Unix())
		}

		if extensionsEvent.EndDateStr != "" {
			time, err := time.Parse(time.RFC3339, extensionsEvent.StartDateStr)
			if err != nil {
				logx.Warn(bCtx, fmt.Sprintf("failed to parse end date while reporting to spade %s: %v", extensionsEvent.EndDateStr, err))
			}
			extensionsEvent.EndDate = float64(time.Unix())
		}
		err = c.spade.TrackEvent(bCtx, "insights_games_api_usage", extensionsEvent)
		if err != nil {
			logx.Error(bCtx, fmt.Sprintf("failed to track event for user %s", extensionsEvent.UserID), logx.Fields{
				"extension_id": extensionsEvent.DomainID,
			})
		}
	}()
}
