package extensions

import (
	"code.justin.tv/chat/golibs/errx"
	"golang.org/x/net/context"
)

func (c *extensionsRepoImpl) getValidUserExtensions(ctx context.Context, userID, extensionID string) ([]string, error) {
	// Access to a single extension is already validated by UserCanAccess.
	// https://git.xarth.tv/insights/piper-service/blob/master/api/get_external.go#L97
	if extensionID != "" {
		return []string{extensionID}, nil
	}

	extensionIDs, err := c.owl.GetExtensionsByUserID(ctx, userID)
	if err != nil {
		return nil, errx.New(err)
	}

	return extensionIDs, nil
}
