package games

import (
	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

func (c *gamesRepoImpl) CreateUploadServiceRequest(ctx context.Context, userID, gameID string, config config.PiperConfig) (*models.BoxArtUpload, error) {
	gameName, err := c.discoveryclient.GetGameNameByID(ctx, gameID)
	if err != nil {
		return nil, errx.New(err)
	}

	resp, err := c.uploaderclient.CreateUploadServiceRequest(ctx, gameID, gameName, config)
	if err != nil {
		return nil, errx.New(err)
	}

	return &models.BoxArtUpload{UploadID: resp.UploadId, URL: resp.Url}, nil
}
