package games

import (
	"code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/lib/reports"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

func (c *gamesRepoImpl) GetReportTypes(ctx context.Context, userID string, gameID string, config config.PiperConfig) (*models.GameReportType, error) {

	gameReportType := models.GameReportType{GameID: gameID, ReportTypes: []string{}}

	// prefilter report type for dev site integration
	reportType := reports.DevsiteGamesReportType
	gameIDs, err := c.piperdbclient.GetAvailableDomainsWithReports(ctx, backendDomain, reportType, []string{gameID})
	if err != nil {
		return nil, err
	}

	if len(gameIDs) > 0 {
		gameReportType.ReportTypes = []string{reportType}
	}

	return &gameReportType, nil
}
