package games

import (
	"code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/lib/reports"
	"golang.org/x/net/context"
)

func (c *gamesRepoImpl) GetGameReportByDate(ctx context.Context, gameID, reportType, startDate, endDate string, conf config.PiperConfig) (string, error) {
	startDate, endDate, err := c.GetFittedDateRange(ctx, gameID, reportType, startDate, endDate)
	if err != nil {
		return "", err
	}

	return c.generateReportURL(ctx, "", gameID, reportType, startDate, endDate, conf)
}

func (c *gamesRepoImpl) generateReportURL(ctx context.Context, userID, gameID, reportType, startDate, endDate string, conf config.PiperConfig) (string, error) {
	gameName, err := c.GetGameNameFromDiscovery(ctx, gameID)
	if err != nil {
		return "", err
	}

	report, err := c.piperdbclient.GetGameReportByDate(ctx, gameName, reportType, startDate, endDate)
	if err != nil {
		return "", err
	}

	fileName, err := c.s3report.SaveReportToS3(ctx, report, gameName, reportType, startDate, endDate, conf.ReportBucket, conf.DynamicReportPrefix)
	if err != nil {
		return "", err
	}

	path := conf.DynamicReportPrefix + fileName
	presignedName := reports.GetFileNameNoUUID(fileName)

	return c.s3client.PreSignURL(conf.ReportBucket, path, presignedName, urlExpireMinutes)
}

func (c *gamesRepoImpl) GetFittedDateRange(ctx context.Context, gameID, reportType, startDate, endDate string) (string, string, error) {
	dbStartDate, dbEndDate, err := c.piperdbclient.GetDomainReportDateRange(ctx, backendDomain, reportType, gameID)
	if err != nil {
		return "", "", err
	}

	return reports.GetFittedDateRange(startDate, endDate, dbStartDate, dbEndDate)
}
