package games

import (
	"fmt"

	"code.justin.tv/chat/golibs/errx"
	"code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/lib/reports"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

// GetGameReport will query piper db to get a list of available reports (DevsiteGamesReportType) for the given an user and a list of report types
// startDate and endDate will not be needed as and it will use the latest report date and report retention
func (c *gamesRepoImpl) GetGameReport(ctx context.Context, userID string, config config.PiperConfig) (*models.GameReports, error) {
	result := models.GameReports{}
	// prefilter report type for dev site integration
	reportType := reports.DevsiteGamesReportType

	userOwnedGameIDs, err := c.rbacClient.GetGameIDsByUserID(ctx, userID)
	if len(userOwnedGameIDs) == 0 || err != nil {
		return nil, err
	}

	gameIDs, err := c.piperdbclient.GetAvailableDomainsWithReports(ctx, backendDomain, reportType, userOwnedGameIDs)
	if err != nil {
		return nil, errx.Wrap(err, fmt.Sprintf("failed to get reports for user %s", userID))
	}
	if len(gameIDs) > 0 {
		for _, r := range gameIDs {
			result = append(result, models.GameReport{GameID: r, ReportName: reportType})
		}
	}

	return &result, nil
}
