package games

import (
	"fmt"

	"time"

	"code.justin.tv/chat/golibs/logx"
	"code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

func (c *gamesRepoImpl) TrackGamesReportUsage(ctx context.Context, gamesEvent models.SpadeEvent, config config.PiperConfig) {
	go func() {
		copiedCtx := logx.CopyFields(ctx, context.Background())
		devCtx, _ := context.WithTimeout(copiedCtx, 6*time.Second)
		company, err := c.rbacClient.GetCompanyByUserID(devCtx, gamesEvent.UserID)
		if err != nil && err != models.ErrUserNoCompany {
			logx.Error(devCtx, fmt.Sprintf("failed to get company for user %s: %v", gamesEvent.UserID, err))
		}

		if company.Id != "" {
			gamesEvent.CompanyID = int(company.CurseCompanyId)
			gamesEvent.CompanyIDStr = company.Id
			gamesEvent.CompanyName = company.CompanyName
		}

		usersCtx, _ := context.WithTimeout(copiedCtx, 5*time.Second)
		isStaff, err := c.usersclient.IsStaff(usersCtx, gamesEvent.UserID)
		if err != nil {
			isStaff = false
		}
		gamesEvent.IsStaff = isStaff

		if gamesEvent.DomainID != "" {
			gameCtx, _ := context.WithTimeout(copiedCtx, 5*time.Second)
			if gameName, err := c.discoveryclient.GetGameNameByID(gameCtx, gamesEvent.DomainID); err == nil {
				gamesEvent.DomainName = gameName
			}
		}

		spadeCtx, _ := context.WithTimeout(copiedCtx, 5*time.Second)
		if gamesEvent.StartDateStr != "" {
			time, err := time.Parse(time.RFC3339, gamesEvent.StartDateStr)
			if err != nil {
				logx.Warn(spadeCtx, fmt.Sprintf("failed to parse start date while reporting to spade %s: %v", gamesEvent.StartDateStr, err))
			}
			gamesEvent.StartDate = float64(time.Unix())
		}

		if gamesEvent.EndDateStr != "" {
			time, err := time.Parse(time.RFC3339, gamesEvent.StartDateStr)
			if err != nil {
				logx.Warn(spadeCtx, fmt.Sprintf("failed to parse end date while reporting to spade %s: %v", gamesEvent.EndDateStr, err))
			}
			gamesEvent.EndDate = float64(time.Unix())
		}

		err = c.spadeclient.TrackEvent(spadeCtx, "insights_games_api_usage", gamesEvent)
		if err != nil {
			logx.Error(spadeCtx, fmt.Sprintf("failed to track event for user %s: %v", gamesEvent.UserID, err))
		}
	}()
}
