package games

import (
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"golang.org/x/net/context"
)

func (c *gamesRepoImpl) UserOwnsGame(ctx context.Context, userID, gameID string) (bool, error) {
	isStaff, err := c.usersclient.IsStaff(ctx, userID)
	if isStaff {
		return true, nil
	}

	err = c.rbacClient.Validate(ctx, &rbacrpc.ValidateQuery{
		UserId:       userID,
		ResourceType: "game",
		ResourceId:   gameID,
		Permission:   "games::analytics::view",
	})
	return err == nil, err
}
