package mods

import (
	"code.justin.tv/common/spade-client-go/spade"
	"code.justin.tv/insights/piper-service/backend"
	"code.justin.tv/insights/piper-service/backend/s3report"
	"code.justin.tv/insights/piper-service/internal/clients/elerium"
	"code.justin.tv/insights/piper-service/internal/clients/piperdb"
	"code.justin.tv/insights/piper-service/internal/clients/s3"
	"code.justin.tv/insights/piper-service/internal/clients/users"
	piperconfig "code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

type Backend interface {
	UserCanAccess(ctx context.Context, userID, modID string, config piperconfig.PiperConfig) (bool, *models.Mod, error)
	GetModReports(ctx context.Context, userID string, config piperconfig.PiperConfig) (*models.Reports, error)
	GetModReportURL(ctx context.Context, userID, modID, reportType string, config piperconfig.PiperConfig) (string, error)
	TrackModsReportUsage(ctx context.Context, modsEvent models.SpadeEvent)
}

type modsImpl struct {
	piperdbclient piperdb.Client
	s3Report      s3report.Backend
	s3Client      s3.Client
	eleriumClient elerium.Client
	usersClient   users.Client
	spade         spade.Client
	cacher        backend.Cacher
}

func NewBackend(piperdb piperdb.Client, s3report s3report.Backend, s3client s3.Client, elerium elerium.Client, users users.Client, spadeclient spade.Client, cacher backend.Cacher) (Backend, error) {
	return &modsImpl{
		piperdbclient: piperdb,
		s3Report:      s3report,
		s3Client:      s3client,
		eleriumClient: elerium,
		usersClient:   users,
		spade:         spadeclient,
		cacher:        cacher,
	}, nil
}
