package mods

import (
	"strconv"

	piperConfig "code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/lib/reports"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

func (c *modsImpl) GetModReports(ctx context.Context, userID string, config piperConfig.PiperConfig) (*models.Reports, error) {
	mods, err := c.eleriumClient.GetModsByUserID(ctx, userID, config)
	if mods == nil || err != nil {
		return nil, err
	}

	modIDs := []string{}
	for _, m := range *mods {
		modIDs = append(modIDs, strconv.Itoa(m.Id))
	}

	reportType := reports.DevsiteModsReportType

	modIDs, err = c.piperdbclient.GetAvailableDomainsWithReports(ctx, backendDomain, reportType, modIDs)
	if err != nil {
		return nil, err
	}

	var modReports models.Reports
	if len(modIDs) > 0 {
		for _, r := range modIDs {
			modReports = append(modReports, models.Report{
				ID:         r,
				ReportType: reportType,
			})
		}
	}

	return &modReports, nil
}
