package mods

import (
	"fmt"
	"time"

	"code.justin.tv/chat/golibs/logx"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

func (c *modsImpl) TrackModsReportUsage(ctx context.Context, modsEvent models.SpadeEvent) {
	go func() {
		copiedCtx := logx.CopyFields(ctx, context.Background())
		spadeCtx, _ := context.WithTimeout(copiedCtx, 5*time.Second)

		err := c.spade.TrackEvent(spadeCtx, "insights_games_api_usage", modsEvent)
		if err != nil {
			logx.Error(spadeCtx, fmt.Sprintf("failed to track event for user %s: %v", modsEvent.UserID, err))
		}
	}()
}
