package one_pager

import (
	"sync"

	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

func (o onePagerImpl) AddProfileImageToResp(ctx context.Context, resp *models.GameOnePagerDataResponse) error {
	if resp.BroadcasterStats != nil {
		wg := sync.WaitGroup{}
		broadcasters := *resp.BroadcasterStats
		if broadcasters.TopBroadcaster != nil {
			wg.Add(1)
			go func() {
				defer handlePanicAndWaitGroup(ctx, &wg)
				broadcasters.TopBroadcaster.ProfileImage = o.usersClient.GetUserImage(ctx, broadcasters.TopBroadcaster.Name)
			}()
		}

		if broadcasters.DedicatedBroadcaster != nil {
			wg.Add(1)
			go func() {
				defer handlePanicAndWaitGroup(ctx, &wg)
				broadcasters.DedicatedBroadcaster.ProfileImage = o.usersClient.GetUserImage(ctx, broadcasters.DedicatedBroadcaster.Name)
			}()
		}

		if broadcasters.RisingStar != nil {
			wg.Add(1)
			go func() {
				defer handlePanicAndWaitGroup(ctx, &wg)
				broadcasters.RisingStar.ProfileImage = o.usersClient.GetUserImage(ctx, broadcasters.RisingStar.Name)
			}()
		}
		wg.Wait()
	} else if resp.PopularBroadcasters != nil {
		wg := sync.WaitGroup{}
		for i := range *resp.PopularBroadcasters {
			wg.Add(1)
			go func(i int) {
				defer handlePanicAndWaitGroup(ctx, &wg)
				broadcaster := (*resp.PopularBroadcasters)[i]
				(*resp.PopularBroadcasters)[i].ProfileImage = o.usersClient.GetUserImage(ctx, broadcaster.Name)
			}(i)
		}
		wg.Wait()
	}
	return nil
}
