package one_pager

import (
	"testing"

	"code.justin.tv/insights/piper-service/models"

	"github.com/stretchr/testify/suite"
)

type AddProfileImageTest struct {
	onePagerSuite
}

const userImage1 = "user image 1"
const userImage2 = "user image 2"
const userImage3 = "user image 3"

func (suite *AddProfileImageTest) TestHavingBroadcasterData() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: true,
		SocialStats:      true,
		ExtensionStats:   true,
		DropStats:        true,
		AudienceStats:    true,
	}

	resp, err := makeTestOnePagerResponseWithMissingStatus(presence, true, true)
	suite.NoError(err)

	suite.usersClient.Mock.On("GetUserImage", suite.ctx, resp.BroadcasterStats.TopBroadcaster.Name).Return(userImage1, nil)
	suite.usersClient.Mock.On("GetUserImage", suite.ctx, resp.BroadcasterStats.DedicatedBroadcaster.Name).Return(userImage2, nil)
	suite.usersClient.Mock.On("GetUserImage", suite.ctx, resp.BroadcasterStats.RisingStar.Name).Return(userImage3, nil)

	err = suite.onePagerImpl.AddProfileImageToResp(suite.ctx, &resp)
	suite.NoError(err)

	suite.Equal(resp.BroadcasterStats.TopBroadcaster.ProfileImage, userImage1)
	suite.Equal(resp.BroadcasterStats.DedicatedBroadcaster.ProfileImage, userImage2)
	suite.Equal(resp.BroadcasterStats.RisingStar.ProfileImage, userImage3)
}

func (suite *AddProfileImageTest) TestMissingBroadcasterData() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: false,
		SocialStats:      true,
		ExtensionStats:   true,
		DropStats:        true,
		AudienceStats:    true,
	}

	resp, err := makeTestOnePagerResponseWithMissingStatus(presence, true, true)
	suite.NoError(err)

	suite.usersClient.Mock.On("GetUserImage", suite.ctx, (*resp.PopularBroadcasters)[0].Name).Return(userImage1, nil)
	suite.usersClient.Mock.On("GetUserImage", suite.ctx, (*resp.PopularBroadcasters)[1].Name).Return(userImage2, nil)
	suite.usersClient.Mock.On("GetUserImage", suite.ctx, (*resp.PopularBroadcasters)[2].Name).Return(userImage3, nil)

	err = suite.onePagerImpl.AddProfileImageToResp(suite.ctx, &resp)
	suite.NoError(err)

	suite.Equal((*resp.PopularBroadcasters)[0].ProfileImage, userImage1)
	suite.Equal((*resp.PopularBroadcasters)[1].ProfileImage, userImage2)
	suite.Equal((*resp.PopularBroadcasters)[2].ProfileImage, userImage3)
}

func TestAddProfileImage(t *testing.T) {
	suite.Run(t, new(AddProfileImageTest))
}
