package one_pager

import (
	"testing"

	"code.justin.tv/insights/piper-service/internal/utils"
	"code.justin.tv/insights/piper-service/models"
	"github.com/stretchr/testify/suite"
)

type GetDefaultQuarterStartRangeTest struct {
	onePagerSuite
}

func (suite *GetDefaultQuarterStartRangeTest) TestValidResults() {
	gameQuarterStartRange := models.QuarterStartRange{
		MaxQuarter: "2",
		MaxYear:    "2018",
		MinQuarter: "4",
		MinYear:    "2017",
	}

	suite.piperDBClient.On("GetDefaultQuarterStartRange", suite.ctx).Return(gameQuarterStartRange, nil)

	quarterStartRange, err := suite.onePagerImpl.GetDefaultQuarterStartRange(suite.ctx)
	suite.NoError(err)

	if diff := utils.Equal(quarterStartRange, gameQuarterStartRange); diff != nil {
		suite.T().Error(diff)
	}
}

func TestGetDefaultQuarterStartRangeSuite(t *testing.T) {
	suite.Run(t, new(GetDefaultQuarterStartRangeTest))
}
