package one_pager

import (
	"fmt"

	"testing"

	"code.justin.tv/insights/piper-service/models"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/stretchr/testify/suite"
)

type GetInsightsDownloadURLTest struct {
	onePagerSuite
}

func (suite *GetInsightsDownloadURLTest) SetupTest() {
	suite.onePagerSuite.SetupTest()
}

func (suite *GetInsightsDownloadURLTest) GetInsightsDownloadURLTest() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: true,
		SocialStats:      true,
		ExtensionStats:   true,
		DropStats:        true,
		AudienceStats:    true,
	}

	filename := mainGameName + "_" + reportName + "_" + suite.yearStr + "_" + suite.quarterStr + ".csv"
	rtn := map[string]string{"url": "URL 1"}

	dataBaseReturn, err := makeTestOnePagerDataBasedOnMissingStatus(presence)
	suite.NoError(err)

	expectedFullDataResp, err := makeTestOnePagerResponseWithMissingStatus(presence, true, true)
	suite.NoError(err)

	cachedDataStr, err := makeCacheDataString(expectedFullDataResp, presence, true)
	suite.NoError(err)

	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension1ID).Return(models.ExtensionStats{Id: extension1ID, Name: "extension1Name", Description: "extension1Description", Url: "extension1URL", IconURL: aws.String("extension1IconURL"), SplashURL: aws.String("extension1SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension2ID).Return(models.ExtensionStats{Id: extension2ID, Name: "extension2Name", Description: "extension2Description", Url: "extension2URL", IconURL: aws.String("extension2IconURL"), SplashURL: aws.String("extension2SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension3ID).Return(models.ExtensionStats{Id: extension3ID, Name: "extension3Name", Description: "extension3Description", Url: "extension3URL", IconURL: aws.String("extension3IconURL"), SplashURL: aws.String("extension3SplashURL")}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "21779").Return(models.TopGame{Id: "21779", Name: "gameName1", Percentage: 9.531959895581132, Img: "gameImg1"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "138585").Return(models.TopGame{Id: "138585", Name: "gameName2", Percentage: 5.079686475527248, Img: "gameImg2"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "488552").Return(models.TopGame{Id: "488552", Name: "gameName3", Percentage: 4.368633406825281, Img: "gameImg3"}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "32399").Return(models.TopGame{Id: "32399", Name: "gameName4", Percentage: 14.848803747515351, Img: "gameImg4"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "4885529").Return(models.TopGame{Id: "4885529", Name: "gameNam5", Percentage: 9.94266355838156, Img: "gameImg5"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "217799").Return(models.TopGame{Id: "217799", Name: "gameName6", Percentage: 9.67853060959945, Img: "gameImg6"}, nil)
	suite.discoveryClient.Mock.On("GetGameNameByID", suite.ctx, mainGameID).Return(mainGameName, nil)

	suite.piperDBClient.On("GetGameOnePagerByQuarterAndYear", suite.ctx, mainGameID, suite.startDate).Return(dataBaseReturn, nil)

	suite.s3report.On("SaveReportToS3", suite.ctx, [][]string{}, mainGameName, reportName, suite.yearStr, suite.quarterStr, suite.config).Return(fmt.Sprintf(mainGameName + "_" + reportName + "_" + suite.yearStr + "_" + suite.quarterStr + ".csv"))

	suite.s3Client.On("PreSignURL", "a_bucket", fmt.Sprintf("dynamic/"+filename), filename, urlExpireMinutes).Return("URL 1", nil)

	suite.cacher.On("GetStringProperties", suite.ctx, suite.dateCacheKey).Return("", false)
	suite.cacher.On("GetStringProperties", suite.ctx, suite.onePagerDataCacheKey).Return("", false)
	suite.cacher.On("CacheStringProperties", suite.ctx, suite.onePagerDataCacheKey, cachedDataStr).Return(nil)

	resp, game, err := suite.onePagerImpl.GetGameOnePagerDownloadURL(suite.ctx, mainGameID, suite.yearStr, suite.quarterStr, suite.config)
	suite.NoError(err)
	suite.Equal(suite.T(), resp, rtn)
	suite.Equal(suite.T(), game, mainGameName)

	suite.emsClient.AssertExpectations(suite.T())
	suite.discoveryClient.AssertExpectations(suite.T())
}

func (suite *GetInsightsDownloadURLTest) GetInsightsDownloadURLWithCacheTest() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: true,
		SocialStats:      true,
		ExtensionStats:   true,
		DropStats:        true,
		AudienceStats:    true,
	}

	filename := mainGameName + "_" + reportName + "_" + suite.yearStr + "_" + suite.quarterStr + ".csv"
	rtn := map[string]string{"url": "URL 1"}

	dataBaseReturn, err := makeTestOnePagerDataBasedOnMissingStatus(presence)
	suite.NoError(err)

	expectedFullDataResp, err := makeTestOnePagerResponseWithMissingStatus(presence, true, true)
	suite.NoError(err)

	cachedDataStr, err := makeCacheDataString(expectedFullDataResp, presence, true)
	suite.NoError(err)
	suite.piperDBClient.On("GetGameOnePagerByQuarterAndYear", suite.ctx, mainGameID, suite.startDate).Return(dataBaseReturn, nil)

	suite.s3report.On("SaveReportToS3", suite.ctx, [][]string{}, mainGameName, reportName, suite.yearStr, suite.quarterStr, suite.config).Return(fmt.Sprintf(mainGameName + "_" + reportName + "_" + suite.yearStr + "_" + suite.quarterStr + ".csv"))

	suite.s3Client.On("PreSignURL", "a_bucket", fmt.Sprintf("dynamic/"+filename), filename, urlExpireMinutes).Return("URL 1", nil)

	suite.cacher.On("GetStringProperties", suite.ctx, suite.dateCacheKey).Return("", false)
	suite.cacher.On("GetStringProperties", suite.ctx, suite.onePagerDataCacheKey).Return(cachedDataStr, true)

	resp, game, err := suite.onePagerImpl.GetGameOnePagerDownloadURL(suite.ctx, mainGameID, suite.yearStr, suite.quarterStr, suite.config)
	suite.NoError(err)
	suite.Equal(suite.T(), resp, rtn)
	suite.Equal(suite.T(), game, mainGameName)

	suite.emsClient.AssertExpectations(suite.T())
	suite.discoveryClient.AssertExpectations(suite.T())
}

func TestInsightsDownloadURLSuite(t *testing.T) {
	suite.Run(t, new(GetInsightsDownloadURLTest))
}
