package one_pager

import (
	"testing"

	"github.com/pkg/errors"

	"code.justin.tv/insights/piper-service/internal/utils"
	"code.justin.tv/insights/piper-service/models"
	"github.com/stretchr/testify/suite"
)

type GetQuarterStartRangeTest struct {
	onePagerSuite
}

func (suite *GetQuarterStartRangeTest) TestValidResultsWhenGameIDExists() {
	gameQuarterStartRange := models.QuarterStartRange{
		MaxQuarter: "2",
		MaxYear:    "2018",
		MinQuarter: "4",
		MinYear:    "2017",
	}

	suite.piperDBClient.On("GetQuarterStartRange", suite.ctx, mainGameID).Return(gameQuarterStartRange, nil)

	quarterStartRange, err := suite.onePagerImpl.GetQuarterStartRange(suite.ctx, mainGameID)
	suite.NoError(err)

	if diff := utils.Equal(quarterStartRange, gameQuarterStartRange); diff != nil {
		suite.T().Error(diff)
	}
}

func (suite *GetQuarterStartRangeTest) TestValidResultsWhenGameIDDoesNotExists() {
	gameQuarterStartRange := models.QuarterStartRange{}

	suite.piperDBClient.On("GetQuarterStartRange", suite.ctx, mainGameID).Return(gameQuarterStartRange, errors.New("unexpected error"))

	quarterStartRange, err := suite.onePagerImpl.GetQuarterStartRange(suite.ctx, mainGameID)
	suite.Error(err)

	if diff := utils.Equal(quarterStartRange, gameQuarterStartRange); diff != nil {
		suite.T().Error(diff)
	}
}

func TestGetQuarterStartRangeSuite(t *testing.T) {
	suite.Run(t, new(GetQuarterStartRangeTest))
}
