package one_pager

import (
	"testing"

	"code.justin.tv/insights/piper-service/internal/utils"
	"code.justin.tv/insights/piper-service/models"
	"github.com/stretchr/testify/suite"
)

type ParseCountryTest struct {
	onePagerSuite
}

func (suite *ParseCountryTest) TestParseCountrySuccess() {
	topCountries := suite.onePagerImpl.parseCountry(suite.ctx, risingCountryByViewers)
	if diff := utils.Equal(topCountries, onePagerResponseWithFullData.AudienceStats.TopViewerCountries); diff != nil {
		suite.T().Error(diff)
	}
}

func (suite *ParseCountryTest) TestParseWithOnlyTwoCountries() {
	topCountries := suite.onePagerImpl.parseCountry(suite.ctx, "US,United States,3.50||DZ,Algeria,3.125643023799")
	if diff := utils.Equal(topCountries, []models.TopCountry{
		{Name: "United States", Percentage: 3.50, Code: "US"},
		{Name: "Algeria", Percentage: 3.12564302379, Code: "DZ"},
	}); diff != nil {
		suite.T().Error(diff)
	}
}

func (suite *ParseCountryTest) TestParseWithOnlyOneCountry() {
	topCountries := suite.onePagerImpl.parseCountry(suite.ctx, "US,United States,3.50")
	if diff := utils.Equal(topCountries, []models.TopCountry{
		{Name: "United States", Percentage: 3.50, Code: "US"},
	}); diff != nil {
		suite.T().Error(diff)
	}
}

func (suite *ParseCountryTest) TestParseWithBrokenString() {
	topCountries := suite.onePagerImpl.parseCountry(suite.ctx, "32399")
	if diff := utils.Equal(topCountries, []models.TopCountry{}); diff != nil {
		suite.T().Error(diff)
	}
}

func (suite *ParseCountryTest) TestParseCountryWithOnlyPartialBadString() {
	topCountries := suite.onePagerImpl.parseCountry(suite.ctx, "Algeria,3.50sxx||US,United States,3.50")
	if diff := utils.Equal(topCountries, []models.TopCountry{
		{Name: "United States", Percentage: 3.50, Code: "US"},
	}); diff != nil {
		suite.T().Error(diff)
	}
}

func TestParseCountrySuite(t *testing.T) {
	suite.Run(t, new(ParseCountryTest))
}
