package one_pager

import (
	"fmt"
	"time"

	"code.justin.tv/chat/golibs/logx"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

func (o onePagerImpl) TrackOnePagerUsage(ctx context.Context, onePager models.SpadeEvent) {
	go func() {
		copiedCtx := logx.CopyFields(ctx, context.Background())
		spadeCtx, _ := context.WithTimeout(copiedCtx, 5*time.Second)
		if onePager.StartDateStr != "" {
			time, err := time.Parse(time.RFC3339, onePager.StartDateStr)
			if err != nil {
				logx.Warn(spadeCtx, fmt.Sprintf("failed to parse start date while reporting to spade %s: %v", onePager.StartDateStr, err))
			}
			onePager.StartDate = float64(time.Unix())
		}

		err := o.spadeClient.TrackEvent(spadeCtx, "insights_games_api_usage", onePager)
		if err != nil {
			logx.Error(spadeCtx, fmt.Sprintf("failed to track one pager event for user %s: %v", onePager.UserID, err))
		}
	}()
}
