package one_pager

import (
	"testing"

	"code.justin.tv/insights/piper-service/internal/utils"
	"code.justin.tv/insights/piper-service/models"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/stretchr/testify/suite"
)

type TransferToGameDataRespTest struct {
	onePagerSuite
}

func (suite *TransferToGameDataRespTest) TestTransferToGameDataResponseWithFullStatus() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: true,
		SocialStats:      true,
		ExtensionStats:   true,
		DropStats:        true,
		AudienceStats:    true,
	}

	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension1ID).Return(models.ExtensionStats{Id: extension1ID, Name: "extension1Name", Description: "extension1Description", Url: "extension1URL", IconURL: aws.String("extension1IconURL"), SplashURL: aws.String("extension1SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension2ID).Return(models.ExtensionStats{Id: extension2ID, Name: "extension2Name", Description: "extension2Description", Url: "extension2URL", IconURL: aws.String("extension2IconURL"), SplashURL: aws.String("extension2SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension3ID).Return(models.ExtensionStats{Id: extension3ID, Name: "extension3Name", Description: "extension3Description", Url: "extension3URL", IconURL: aws.String("extension3IconURL"), SplashURL: aws.String("extension3SplashURL")}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "21779").Return(models.TopGame{Id: "21779", Name: "gameName1", Percentage: 9.531959895581132, Img: "gameImg1"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "138585").Return(models.TopGame{Id: "138585", Name: "gameName2", Percentage: 5.079686475527248, Img: "gameImg2"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "488552").Return(models.TopGame{Id: "488552", Name: "gameName3", Percentage: 4.368633406825281, Img: "gameImg3"}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "32399").Return(models.TopGame{Id: "32399", Name: "gameName4", Percentage: 14.848803747515351, Img: "gameImg4"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "4885529").Return(models.TopGame{Id: "4885529", Name: "gameNam5", Percentage: 9.942663558381568, Img: "gameImg5"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "217799").Return(models.TopGame{Id: "217799", Name: "gameName6", Percentage: 9.67853060959945, Img: "gameImg6"}, nil)

	resp, err := suite.onePagerImpl.transferToGameDataResponse(suite.ctx, onePagerWithAllData, &presence)
	suite.NoError(err)

	fullData, err := makeTestOnePagerResponseWithMissingStatus(presence, false, false)
	suite.NoError(err)

	if diff := utils.Equal(resp, fullData); diff != nil {
		suite.T().Error(diff)
	}

	suite.emsClient.AssertExpectations(suite.T())
	suite.discoveryClient.AssertExpectations(suite.T())
}

func (suite *TransferToGameDataRespTest) TestTransferToGameDataResponseWithMissingAudienceData() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: true,
		SocialStats:      true,
		ExtensionStats:   true,
		DropStats:        true,
		AudienceStats:    false,
	}

	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension1ID).Return(models.ExtensionStats{Id: extension1ID, Name: "extension1Name", Description: "extension1Description", Url: "extension1URL", IconURL: aws.String("extension1IconURL"), SplashURL: aws.String("extension1SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension2ID).Return(models.ExtensionStats{Id: extension2ID, Name: "extension2Name", Description: "extension2Description", Url: "extension2URL", IconURL: aws.String("extension2IconURL"), SplashURL: aws.String("extension2SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension3ID).Return(models.ExtensionStats{Id: extension3ID, Name: "extension3Name", Description: "extension3Description", Url: "extension3URL", IconURL: aws.String("extension3IconURL"), SplashURL: aws.String("extension3SplashURL")}, nil)

	resp, err := suite.onePagerImpl.transferToGameDataResponse(suite.ctx, onePagerWithAllData, &presence)
	suite.NoError(err)

	fullData, err := makeTestOnePagerResponseWithMissingStatus(presence, false, false)
	suite.NoError(err)

	if diff := utils.Equal(resp, fullData); diff != nil {
		suite.T().Error(diff)
	}

	suite.emsClient.AssertExpectations(suite.T())
}

func (suite *TransferToGameDataRespTest) TestTransferToGameDataResponseWithMissingDropsStats() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: true,
		SocialStats:      true,
		ExtensionStats:   true,
		DropStats:        false,
		AudienceStats:    true,
	}

	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension1ID).Return(models.ExtensionStats{Id: extension1ID, Name: "extension1Name", Description: "extension1Description", Url: "extension1URL", IconURL: aws.String("extension1IconURL"), SplashURL: aws.String("extension1SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension2ID).Return(models.ExtensionStats{Id: extension2ID, Name: "extension2Name", Description: "extension2Description", Url: "extension2URL", IconURL: aws.String("extension2IconURL"), SplashURL: aws.String("extension2SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension3ID).Return(models.ExtensionStats{Id: extension3ID, Name: "extension3Name", Description: "extension3Description", Url: "extension3URL", IconURL: aws.String("extension3IconURL"), SplashURL: aws.String("extension3SplashURL")}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "21779").Return(models.TopGame{Id: "21779", Name: "gameName1", Percentage: 9.531959895581132, Img: "gameImg1"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "138585").Return(models.TopGame{Id: "138585", Name: "gameName2", Percentage: 5.079686475527248, Img: "gameImg2"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "488552").Return(models.TopGame{Id: "488552", Name: "gameName3", Percentage: 4.368633406825281, Img: "gameImg3"}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "32399").Return(models.TopGame{Id: "32399", Name: "gameName4", Percentage: 14.848803747515351, Img: "gameImg4"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "4885529").Return(models.TopGame{Id: "4885529", Name: "gameNam5", Percentage: 9.942663558381568, Img: "gameImg5"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "217799").Return(models.TopGame{Id: "217799", Name: "gameName6", Percentage: 9.67853060959945, Img: "gameImg6"}, nil)

	resp, err := suite.onePagerImpl.transferToGameDataResponse(suite.ctx, onePagerWithAllData, &presence)
	suite.NoError(err)

	fullData, err := makeTestOnePagerResponseWithMissingStatus(presence, false, false)
	suite.NoError(err)

	if diff := utils.Equal(resp, fullData); diff != nil {
		suite.T().Error(diff)
	}

	suite.emsClient.AssertExpectations(suite.T())
	suite.discoveryClient.AssertExpectations(suite.T())
}

func (suite *TransferToGameDataRespTest) TestTransferToGameDataResponseWithMissingExtensionStats() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: true,
		SocialStats:      true,
		ExtensionStats:   false,
		DropStats:        true,
		AudienceStats:    true,
	}

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "21779").Return(models.TopGame{Id: "21779", Name: "gameName1", Percentage: 9.531959895581132, Img: "gameImg1"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "138585").Return(models.TopGame{Id: "138585", Name: "gameName2", Percentage: 5.079686475527248, Img: "gameImg2"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "488552").Return(models.TopGame{Id: "488552", Name: "gameName3", Percentage: 4.368633406825281, Img: "gameImg3"}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "32399").Return(models.TopGame{Id: "32399", Name: "gameName4", Percentage: 14.848803747515351, Img: "gameImg4"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "4885529").Return(models.TopGame{Id: "4885529", Name: "gameNam5", Percentage: 9.942663558381568, Img: "gameImg5"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "217799").Return(models.TopGame{Id: "217799", Name: "gameName6", Percentage: 9.67853060959945, Img: "gameImg6"}, nil)

	resp, err := suite.onePagerImpl.transferToGameDataResponse(suite.ctx, onePagerWithAllData, &presence)
	suite.NoError(err)

	fullData, err := makeTestOnePagerResponseWithMissingStatus(presence, false, false)
	suite.NoError(err)

	if diff := utils.Equal(resp, fullData); diff != nil {
		suite.T().Error(diff)
	}

	suite.discoveryClient.AssertExpectations(suite.T())
}

func (suite *TransferToGameDataRespTest) TestTransferToGameDataResponseWithMissingSocialStats() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: true,
		SocialStats:      false,
		ExtensionStats:   true,
		DropStats:        true,
		AudienceStats:    true,
	}

	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension1ID).Return(models.ExtensionStats{Id: extension1ID, Name: "extension1Name", Description: "extension1Description", Url: "extension1URL", IconURL: aws.String("extension1IconURL"), SplashURL: aws.String("extension1SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension2ID).Return(models.ExtensionStats{Id: extension2ID, Name: "extension2Name", Description: "extension2Description", Url: "extension2URL", IconURL: aws.String("extension2IconURL"), SplashURL: aws.String("extension2SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension3ID).Return(models.ExtensionStats{Id: extension3ID, Name: "extension3Name", Description: "extension3Description", Url: "extension3URL", IconURL: aws.String("extension3IconURL"), SplashURL: aws.String("extension3SplashURL")}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "21779").Return(models.TopGame{Id: "21779", Name: "gameName1", Percentage: 9.531959895581132, Img: "gameImg1"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "138585").Return(models.TopGame{Id: "138585", Name: "gameName2", Percentage: 5.079686475527248, Img: "gameImg2"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "488552").Return(models.TopGame{Id: "488552", Name: "gameName3", Percentage: 4.368633406825281, Img: "gameImg3"}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "32399").Return(models.TopGame{Id: "32399", Name: "gameName4", Percentage: 14.848803747515351, Img: "gameImg4"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "4885529").Return(models.TopGame{Id: "4885529", Name: "gameNam5", Percentage: 9.942663558381568, Img: "gameImg5"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "217799").Return(models.TopGame{Id: "217799", Name: "gameName6", Percentage: 9.67853060959945, Img: "gameImg6"}, nil)

	resp, err := suite.onePagerImpl.transferToGameDataResponse(suite.ctx, onePagerWithAllData, &presence)
	suite.NoError(err)

	fullData, err := makeTestOnePagerResponseWithMissingStatus(presence, false, false)
	suite.NoError(err)

	if diff := utils.Equal(resp, fullData); diff != nil {
		suite.T().Error(diff)
	}

	suite.emsClient.AssertExpectations(suite.T())
	suite.discoveryClient.AssertExpectations(suite.T())
}

func (suite *TransferToGameDataRespTest) TestTransferToGameDataResponseWithMissingBroadcasterStats() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: false,
		SocialStats:      true,
		ExtensionStats:   true,
		DropStats:        true,
		AudienceStats:    true,
	}

	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension1ID).Return(models.ExtensionStats{Id: extension1ID, Name: "extension1Name", Description: "extension1Description", Url: "extension1URL", IconURL: aws.String("extension1IconURL"), SplashURL: aws.String("extension1SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension2ID).Return(models.ExtensionStats{Id: extension2ID, Name: "extension2Name", Description: "extension2Description", Url: "extension2URL", IconURL: aws.String("extension2IconURL"), SplashURL: aws.String("extension2SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension3ID).Return(models.ExtensionStats{Id: extension3ID, Name: "extension3Name", Description: "extension3Description", Url: "extension3URL", IconURL: aws.String("extension3IconURL"), SplashURL: aws.String("extension3SplashURL")}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "21779").Return(models.TopGame{Id: "21779", Name: "gameName1", Percentage: 9.531959895581132, Img: "gameImg1"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "138585").Return(models.TopGame{Id: "138585", Name: "gameName2", Percentage: 5.079686475527248, Img: "gameImg2"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "488552").Return(models.TopGame{Id: "488552", Name: "gameName3", Percentage: 4.368633406825281, Img: "gameImg3"}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "32399").Return(models.TopGame{Id: "32399", Name: "gameName4", Percentage: 14.848803747515351, Img: "gameImg4"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "4885529").Return(models.TopGame{Id: "4885529", Name: "gameNam5", Percentage: 9.942663558381568, Img: "gameImg5"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "217799").Return(models.TopGame{Id: "217799", Name: "gameName6", Percentage: 9.67853060959945, Img: "gameImg6"}, nil)

	resp, err := suite.onePagerImpl.transferToGameDataResponse(suite.ctx, onePagerWithAllData, &presence)
	suite.NoError(err)

	fullData, err := makeTestOnePagerResponseWithMissingStatus(presence, false, false)
	suite.NoError(err)

	if diff := utils.Equal(resp, fullData); diff != nil {
		suite.T().Error(diff)
	}

	suite.emsClient.AssertExpectations(suite.T())
	suite.discoveryClient.AssertExpectations(suite.T())
}

func (suite *TransferToGameDataRespTest) TestTransferToGameDataResponseWithMissingOverviewStats() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    false,
		BroadcasterStats: true,
		SocialStats:      true,
		ExtensionStats:   true,
		DropStats:        true,
		AudienceStats:    true,
	}

	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension1ID).Return(models.ExtensionStats{Id: extension1ID, Name: "extension1Name", Description: "extension1Description", Url: "extension1URL", IconURL: aws.String("extension1IconURL"), SplashURL: aws.String("extension1SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension2ID).Return(models.ExtensionStats{Id: extension2ID, Name: "extension2Name", Description: "extension2Description", Url: "extension2URL", IconURL: aws.String("extension2IconURL"), SplashURL: aws.String("extension2SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension3ID).Return(models.ExtensionStats{Id: extension3ID, Name: "extension3Name", Description: "extension3Description", Url: "extension3URL", IconURL: aws.String("extension3IconURL"), SplashURL: aws.String("extension3SplashURL")}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "21779").Return(models.TopGame{Id: "21779", Name: "gameName1", Percentage: 9.531959895581132, Img: "gameImg1"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "138585").Return(models.TopGame{Id: "138585", Name: "gameName2", Percentage: 5.079686475527248, Img: "gameImg2"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "488552").Return(models.TopGame{Id: "488552", Name: "gameName3", Percentage: 4.368633406825281, Img: "gameImg3"}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "32399").Return(models.TopGame{Id: "32399", Name: "gameName4", Percentage: 14.848803747515351, Img: "gameImg4"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "4885529").Return(models.TopGame{Id: "4885529", Name: "gameNam5", Percentage: 9.942663558381568, Img: "gameImg5"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "217799").Return(models.TopGame{Id: "217799", Name: "gameName6", Percentage: 9.67853060959945, Img: "gameImg6"}, nil)

	resp, err := suite.onePagerImpl.transferToGameDataResponse(suite.ctx, onePagerWithAllData, &presence)
	suite.NoError(err)

	fullData, err := makeTestOnePagerResponseWithMissingStatus(presence, false, false)
	suite.NoError(err)

	if diff := utils.Equal(resp, fullData); diff != nil {
		suite.T().Error(diff)
	}

	suite.emsClient.AssertExpectations(suite.T())
	suite.discoveryClient.AssertExpectations(suite.T())
}

func (suite *TransferToGameDataRespTest) TestTransferToGameDataResponseWithAllEMSFailures() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: true,
		SocialStats:      true,
		ExtensionStats:   true,
		DropStats:        true,
		AudienceStats:    true,
	}

	presenceWithoutExtensions := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: true,
		SocialStats:      true,
		ExtensionStats:   false,
		DropStats:        true,
		AudienceStats:    true,
	}

	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension1ID).Return(models.ExtensionStats{Id: extension1ID, Name: "extension1Name", Description: "extension1Description", Url: "extension1URL", IconURL: aws.String("extension1IconURL"), SplashURL: aws.String("extension1SplashURL")}, models.ErrResourceNotFound)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension2ID).Return(models.ExtensionStats{Id: extension2ID, Name: "extension2Name", Description: "extension2Description", Url: "extension2URL", IconURL: aws.String("extension2IconURL"), SplashURL: aws.String("extension2SplashURL")}, models.ErrResourceNotFound)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension3ID).Return(models.ExtensionStats{Id: extension3ID, Name: "extension3Name", Description: "extension3Description", Url: "extension3URL", IconURL: aws.String("extension3IconURL"), SplashURL: aws.String("extension3SplashURL")}, models.ErrResourceNotFound)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "21779").Return(models.TopGame{Id: "21779", Name: "gameName1", Percentage: 9.531959895581132, Img: "gameImg1"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "138585").Return(models.TopGame{Id: "138585", Name: "gameName2", Percentage: 5.079686475527248, Img: "gameImg2"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "488552").Return(models.TopGame{Id: "488552", Name: "gameName3", Percentage: 4.368633406825281, Img: "gameImg3"}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "32399").Return(models.TopGame{Id: "32399", Name: "gameName4", Percentage: 14.848803747515351, Img: "gameImg4"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "4885529").Return(models.TopGame{Id: "4885529", Name: "gameNam5", Percentage: 9.942663558381568, Img: "gameImg5"}, nil)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "217799").Return(models.TopGame{Id: "217799", Name: "gameName6", Percentage: 9.67853060959945, Img: "gameImg6"}, nil)

	resp, err := suite.onePagerImpl.transferToGameDataResponse(suite.ctx, onePagerWithAllData, &presence)
	suite.NoError(err)

	fullData, err := makeTestOnePagerResponseWithMissingStatus(presenceWithoutExtensions, false, false)
	suite.NoError(err)

	if diff := utils.Equal(resp, fullData); diff != nil {
		suite.T().Error(diff)
	}

	if diff := utils.Equal(presence, presenceWithoutExtensions); diff != nil {
		suite.T().Error(diff)
	}

	suite.emsClient.AssertExpectations(suite.T())
	suite.discoveryClient.AssertExpectations(suite.T())
}

func (suite *TransferToGameDataRespTest) TestTransferToGameDataResponseWithAllDiscoveryFailures() {
	presence := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: true,
		SocialStats:      true,
		ExtensionStats:   true,
		DropStats:        true,
		AudienceStats:    true,
	}

	presenceWithoutGames := models.OnePagerSectionPresentStatus{
		OverviewStats:    true,
		BroadcasterStats: true,
		SocialStats:      true,
		ExtensionStats:   true,
		DropStats:        true,
		AudienceStats:    false,
	}

	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension1ID).Return(models.ExtensionStats{Id: extension1ID, Name: "extension1Name", Description: "extension1Description", Url: "extension1URL", IconURL: aws.String("extension1IconURL"), SplashURL: aws.String("extension1SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension2ID).Return(models.ExtensionStats{Id: extension2ID, Name: "extension2Name", Description: "extension2Description", Url: "extension2URL", IconURL: aws.String("extension2IconURL"), SplashURL: aws.String("extension2SplashURL")}, nil)
	suite.emsClient.Mock.On("GetReleasedExtensionByID", suite.ctx, extension3ID).Return(models.ExtensionStats{Id: extension3ID, Name: "extension3Name", Description: "extension3Description", Url: "extension3URL", IconURL: aws.String("extension3IconURL"), SplashURL: aws.String("extension3SplashURL")}, nil)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "21779").Return(models.TopGame{Id: "21779", Name: "gameName1", Percentage: 9.531959895581132, Img: "gameImg1"}, models.ErrResourceNotFound)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "138585").Return(models.TopGame{Id: "138585", Name: "gameName2", Percentage: 5.079686475527248, Img: "gameImg2"}, models.ErrResourceNotFound)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "488552").Return(models.TopGame{Id: "488552", Name: "gameName3", Percentage: 4.368633406825281, Img: "gameImg3"}, models.ErrResourceNotFound)

	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "32399").Return(models.TopGame{Id: "32399", Name: "gameName4", Percentage: 14.848803747515351, Img: "gameImg4"}, models.ErrResourceNotFound)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "4885529").Return(models.TopGame{Id: "4885529", Name: "gameNam5", Percentage: 9.942663558381568, Img: "gameImg5"}, models.ErrResourceNotFound)
	suite.discoveryClient.Mock.On("GetGameByID", suite.ctx, "217799").Return(models.TopGame{Id: "217799", Name: "gameName6", Percentage: 9.67853060959945, Img: "gameImg6"}, models.ErrResourceNotFound)

	resp, err := suite.onePagerImpl.transferToGameDataResponse(suite.ctx, onePagerWithAllData, &presence)
	suite.NoError(err)

	fullData, err := makeTestOnePagerResponseWithMissingStatus(presenceWithoutGames, false, false)
	suite.NoError(err)

	if diff := utils.Equal(resp, fullData); diff != nil {
		suite.T().Error(diff)
	}

	if diff := utils.Equal(presence, presenceWithoutGames); diff != nil {
		suite.T().Error(diff)
	}

	suite.emsClient.AssertExpectations(suite.T())
	suite.discoveryClient.AssertExpectations(suite.T())
}

func TestTransferToGameDataRespSuite(t *testing.T) {
	suite.Run(t, new(TransferToGameDataRespTest))
}
