package one_pager

import (
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"golang.org/x/net/context"
)

var whitelistedUsers = map[string]bool{
	"134097367": true, // kevipike -- kevin pike
	"131180913": true, // gigaccat -- shiming
	"132754217": true, // tothemario -- Mario Izquierdo
	"155668964": true, // qtbros -- meng
	"96046250":  true, // cado -- cado
	"43528332":  true, // madhatter
	"57423218":  true, // kristin
	"189904313": true, // tarun
	"14619126":  true, // ernie
	"58965043":  true, // bertreynoldz
	"8673744":   true, // imjim622
	"42549188":  true, // hambino
	"38263992":  true, // KyleDoner
	"57164743":  true, // king_thony
	"151819967": true, // mjgillis
	"183877919": true, // dabighoota
	"100756748": true, // owlsquid
	"76940227":  true, // taykell
	"140610527": true, // angpt
	"142013217": true, // namelessaccursed
	"11961952":  true, // Kain
	"44635596":  true, // ConcreteEntree
	"36955":     true, // drea630
	"158038007": true, // Meka
	"45534323":  true, // joshshaw
	"234983773": true, // kiruluta
	"216526278": true, // thehondurasjones
	"53439701":  true, // bescuseme
	"21588923":  true, // Eroot
	"141005496": true, // darth_hoff
	"139501692": true, // ktopenn
	"8434":      true, // scott
	"135093069": true, // BlueLava
	"31327358":  true, // Ryz0n
	"208258100": true, // val
	"27419011":  true, // travistyoj
	"217265723": true, // ronniebabes
	"179206641": true, // NintendudeSSB
	"19466852":  true, // ???
	"119623781": true, // joygirl007
	"41264107":  true, // ThePartyMenu
	"150573462": true, // Amorelandra
	"133779621": true, // dhrulez
	"85528419":  true, // colan
	"29919503":  true, // shaun
	"54591721":  true, // merrykish
	"4221521":   true, // djwheat
	"122483513": true, // bryankyt
	"151056186": true, // pakkoq
	"118463535": true, // reidr
	"54703138":  true, // Jamesbot
	"191943869": true, // cfort9
	"13857686":  true, // whisenhunt
	"27940945":  true, // mikulthegreat
	"26621620":  true, // chaud
	"69496199":  true, // dcchoi
	"5582097":   true, // sarbandia
	"42372839":  true, // bluesandoz
	"58861522":  true, // mb0we
	"121140546": true, // kiro_77
	"122879696": true, // caiomello
	"114594414": true, // mikecheb
	"195000326": true, // thebkzr13
	"107526772": true, // icarus
	"70245739":  true, // arslin
	"139532026": true, // teco
	"37045055":  true, // gdb
	"26686797":  true, // pugget
	"47269872":  true, // captainzhao
	"7267742":   true, // carsonf
	"103838077": true, // 2chengz
	"102150440": true, // asagalovsky
	"115876539": true, // dcwcd
	"156645415": true, // shrayes
	"226376312": true, // carolssnz
	"24362887":  true, // vol1tion
	"144016774": true, // beautynwhiskey
	"49709777":  true, // shark
	"234882118": true, // therealharveydent
	"187982396": true, // Id00dsi
	"184009112": true, // pichuran
	"83316181":  true, // igor
	"28337238":  true, // obake2
	"235767915": true, // chowmp
	"87132":     true, // diogee
	"264507335": true, // sheistara
	"27389919":  true, // baroncast
	"6258630":   true, // dzabdi88
	"29832698":  true, // m1lkcast
	"224925015": true, // kiyotaki_sanju
	"156900877": true, // baxter4343
}

func (o onePagerImpl) UserCanAccess(ctx context.Context, userID, gameID, companyID string) (bool, error) {
	if _, userFound := whitelistedUsers[userID]; userFound {
		return true, nil
	}

	return false, o.rbacClient.Validate(ctx, &rbacrpc.ValidateQuery{
		UserId:       userID,
		ResourceType: "game",
		ResourceId:   gameID,
		Permission:   "insights-1pager::view",
	})
}
