package s3report

import (
	"code.justin.tv/insights/piper-service/internal/clients/s3"
	"golang.org/x/net/context"
)

const (
	s3delim = "/"
)

//go:generate mockery -name Backend
type Backend interface {
	SaveReportToS3(ctx context.Context, report [][]string, domainKey, reportType, startDate, endDate, bucket, prefix string) (string, error)
}

type s3ReportBackendImpl struct {
	s3client s3.Client
}

func NewBackend(s3client s3.Client) (Backend, error) {
	return &s3ReportBackendImpl{
		s3client: s3client,
	}, nil
}
