package s3report

import (
	"testing"

	"code.justin.tv/insights/piper-service/internal/clients/s3/mocks"
	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/require"
	"golang.org/x/net/context"
)

func TestSaveReportToS3(t *testing.T) {
	s3mock := &mocks.Client{}

	client := &s3ReportBackendImpl{
		s3client: s3mock,
	}

	s3mock.On("UploadFileToS3", mock.Anything, mock.Anything, mock.Anything).Return("filename", nil)

	for _, name := range []string{
		"DeathQuotes / Death Quotes",
		"Diablo",
	} {
		t.Run(name, func(t *testing.T) {
			_, err := client.SaveReportToS3(context.Background(), nil, name, "overview_v1", "yesterday", "today", "twitch-piper-reports", "dynamic")
			require.NoError(t, err)
		})
	}

}

func TestISO8850_1(t *testing.T) {
	require.Equal(t, "Reeses Egg Hunt_overview_v2_2019-04-12_2019-04-14.csv", toISO8859_1("Reese’s Egg Hunt_overview_v2_2019-04-12_2019-04-14.csv"))

	require.Equal(t, "TrackMania² Canyon", toISO8859_1("TrackMania² Canyon"))
}
