import * as elbv2 from '@aws-cdk/aws-elasticloadbalancingv2';
import * as cdk from '@aws-cdk/core';

export interface AlbStackProps extends cdk.StackProps {
  loadBalancerArn: string;
  loadBalancerDnsName: string;
  securityGroupId: string;
  listenerArn: string;
}

// Import the already existing Application Load Balancer to expose it in CDK.
// The load balancer is part of a Beanstalk app.
export class AlbStack extends cdk.Stack {
  public readonly alb: elbv2.IApplicationLoadBalancer;
  public readonly albListener: elbv2.IApplicationListener;

  constructor(scope: cdk.Construct, name: string, props: AlbStackProps) {
    super(scope, name, props);

    this.alb = elbv2.ApplicationLoadBalancer.fromApplicationLoadBalancerAttributes(this, 'ImportedAlb', {
      loadBalancerArn: props.loadBalancerArn,
      loadBalancerDnsName: props.loadBalancerDnsName,
      securityGroupId: props.securityGroupId,
    });

    this.albListener = elbv2.ApplicationListener.fromApplicationListenerAttributes(this, 'ImportedAlbListener', {
      listenerArn: props.listenerArn,
      securityGroupId: props.securityGroupId,
    });
  }
}
