# Piper Service API

## Endpoints

| Function | Method | Url |
|---------|:------:|-----|
| [Retrieve all available game and report types](#get-reportgamesuserid) | GET | `/report/games/<userid>` |
| [Retrieve report types for a game](#get-reportgamesuseridgameid) | GET | `/report/games/<userid>/<gameid>` |
| [Retrieve report download URL for a game and report type between specific start date and end date](#get-reportgamesuseridgameidreporttypestart_dateend_date) | GET | `/report/games/<userid>/<gameid>/<reporttype>?start_date=<startdate>&end_date=<enddate>` |
| [Retrieve report download URL for the latest downloadable report](#get-reportgamesuseridgameidreporttypelatest) | GET | `/report/games/<userid>/<gameid>/<reporttype>/latest` |
| [Retrieve report types for an extension](#get-reportextensionsuseridextensionid) | GET | `/report/extensions/<userid>/<extensionid>` |
| [Retrieve report download URL for an extension and report type between specific start date and end date](#get-reportextensionsuseridextensionidreporttypestart_dateend_date) | GET | `/report/extensions/<userid>/<extensionid>/<reporttype>?start_date=<startdate>&end_date=<enddate>` |
| [Retrieve report download URL for the latest downloadable report](#get-reportextensionsuseridextensionidreporttypelatest) | GET | `/report/extensions/<userid>/<extensionid>/<reporttype>/latest` |
| [Retrieve a filterable set of download URLs of games](#get-helixreportgamesuseridgame_idtypeoffsetlimitstart_dateend_date) | GET | `/helix/report/games/<userid>?game_id=<gameid>&type=<reporttype>&offset=<offset>&limit=<limit>&start_date=<startdate>&end_date=<enddate>` |
| [Retrieve a filterable set of download URLs of extensions](#get-helixreportextensionsuseridextension_idtypereport) | GET | `/helix/report/extensions/<userid>?extension_id=<extensionid>&type=<reporttype>&report=<report>` |
| [Retrieve a pre signed URL for a game to upload its BoxArt image](#get-boxartuploaduseridgame) | GET | `/boxart/upload/<userid>/<game>` |
| [Retrieve one set of game insights data for one pager feature](#get-onepagergamesuser_idgame_id) | GET | `/onepager/games/<user_id>/<game_id>` |
| [Retrieve year and quarter for first and last quarters](#get-onepagergamesuser_idgame_idquarterstartrange) | GET | `/onepager/games/<user_id>/<game_id>/quarterstartrange` |
| [Retrieve all available mod and report types](#get-reportmodsuser_id) | GET | `/report/mods/<user_id>` |
| [Retrieve a download URL for the latest report](#get-reportmodsuser_idmod_idreport_typelatest) | GET | `/report/mods/<user_id>/<mod_id>/<report_type>/latest` |

## Responses

Piper responses are always JSON objects, with content type `application/json;charset=utf-8`.  Each endpoint has a unique success response
 format, and all endpoints share a single JSON format for error states.

### Errors

Piper requests can return the following HTTP Status Codes and error messages

| HTTP Response Code | Error | Meaning |
|-------------------:|:-----:|---------|
| 400 | User Not Found | The specified userID does not map to a real twitch user. |
| 400 | Invalid Game ID | The specified gameID does not map to a real game. |
| 400 | Invalid Date Format | The start date is more recent than the end date in dynamic dates selection. |
| 400 | Invalid Offset | The offset in the request is incorrect. |
| 400 | Invalid Limit | The limit if the request is incorrect. |
| 403 | User Has No Access To Company | The specified userID is a real twitch user who does not have access to any DevPortal company. |
| 403 | User Has No Access To Games | The specified userID is a real twitch user who belongs to a DevPortal company but does not have access to any game. |
| 403 | Game Not Associated To Company | The specified game is a real game but is not associated to any DevPortal company. |
| 403 | Access Forbidden | Generic Access forbidden. |
| 404 | Report Not Found | No report which maps to the request parameters exists in S3, or a report type was requested which is not open to the public. |
| 404 | Game Name Not Found | The specified gameID does not map to a game in the twitch discovery database. |
| 404 | Resource Not Found | The specified resources are not found. |
| 404 | User Does Not Have Extensions | The specified userID does not have any extension in the twitch owl database. |
| 404 | Report Not Found For Date Range | Both the start date and the end date are out of bound of the default dates of the specific report type. |
| 404 | User Does Not Have Mods | The specified userID does not own any mods. |
| 500 | Internal Error | Internal Error |

Any other response indicates a bug in the piper backend, and should be reported to us.

### Response Objects

In the following examples, we use the userID `279539145` to show how to make a request and what to expect from the response body. Please replace it with your own userID to get the correct authentification and authorization. Otherwise you may run into `AccessForbidden` error.

### GET /report/games/:userid
e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/games/279539145](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/games/279539145)

Retrieves all available games and report types the specified user ID has access to.  The response object is formatted like this:

    {
        "reports": [
            {
                "game_id": "111",
                "report": "overview_v2"
            },
            ...
        ]
    }

The listed game/report pairs comprise the intersection of all games and all report types that the user is authorized to retrieve and for which a downloadable report exists.

### GET /report/games/:userid/:gameid
e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/games/279539145/488552](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/games/279539145/488552)

Retrieves all available report types for the given game that the given user has access to.  The response object is formatted like this:

    {
        "reports": {
            "game": "111",
            "reports": [
                "overview_v2"
            ]
        }
    }

The listed report types comprise the entire list of report types that the user is authorized to retrieve for the given game, and for which a downloadable report exists.

### GET /report/games/:userid/:gameid/:reporttype?start_date=&end_date=

e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/games/279539145/488552/overview_v2?start_date=2018-03-01T00:00:00Z&end_date=2018-04-01T00:00:00Z](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/games/279539145/488552/overview_v2?start_date=2018-03-01T00:00:00Z&end_date=2018-04-01T00:00:00Z)

Retrieves a download URL for the given game and report type with the date range that the given user has access to.
Note: date format requires RFC 3339, and start_date and end_date can be left off. It will use the default start date and end date of the specific report type, e.g overview_v1 report is from 90 days ago to date and overview_v2 report is 365 days ago to date.

    {
        "url": "http://twitch-piper-reports.s3-us-west-2.amazonaws.com/dynamic/game1_overview_v2_2018-03-01_2018-04-01_*?AWSAccessKeyId=***&Expires=1499898667&Signature=***"
    }

### GET /report/games/:userid/:gameid/:reporttype/latest

e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/games/279539145/488552/overview_v2/latest](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/games/279539145/488552/overview_v2/latest)

    {
        "url": "http://twitch-piper-reports.s3-us-west-2.amazonaws.com/game/111/default/20170712T000113Z?AWSAccessKeyId=***&Expires=1499898667&Signature=***"
    }

Retrieves a download URL for the most recent report for the given game and report type.

### GET /report/extensions/:userid/:extensionid
e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/extensions/29279425/kr7m1hz7esldlrptruk0fd76l6yq36](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/games/279539145/kr7m1hz7esldlrptruk0fd76l6yq36)

Retrieves all available report types for the given extension that the given user has access to. Note: extension_id is Client-ID. The response object is formatted like this:

    {
        "reports": {
            "id": "kr7m1hz7esldlrptruk0fd76l6yq36",
            "report_types": [
                "overview"
            ]
        }
    }

The listed report types comprise the entire list of report types that the user is authorized to retrieve for the given extension, and for which a downloadable report exists.

### GET /report/extensions/:userid/:extensionid/:reporttype?start_date=&end_date=

e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/extensions/279539145/kr7m1hz7esldlrptruk0fd76l6yq36/overview?start_date=2018-03-01T00:00:00Z&end_date=2018-04-01T00:00:00Z](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/games/279539145/kr7m1hz7esldlrptruk0fd76l6yq36/overview?start_date=2018-03-01T00:00:00Z&end_date=2018-04-01T00:00:00Z)

Retrieves a download URL for the given extension and report type with the date range that the given user has access to.
Note: date format requires RFC 3339, and start_date and end_date can be left off. It will use the default start date and end date of the specific report type, e.g overview report is from 90 days ago to date.

    {
        "url": "http://twitch-piper-reports.s3-us-west-2.amazonaws.com/dynamic/extension1_overview_2018-03-01_2018-04-01_*?AWSAccessKeyId=***&Expires=1499898667&Signature=***"
    }

### GET /report/extensions/:userid/:extensionid/:reporttype/latest

e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/extensions/279539145/kr7m1hz7esldlrptruk0fd76l6yq36/overview/latest](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/extensions/279539145/kr7m1hz7esldlrptruk0fd76l6yq36/overview/latest)

    {
        "url": "http://twitch-piper-reports.s3-us-west-2.amazonaws.com/extensions/279539145/kr7m1hz7esldlrptruk0fd76l6yq36/20170712T000113Z?AWSAccessKeyId=***&Expires=1499898667&Signature=***"
    }

Retrieves a download URL for the most recent report for the given game and report type.

### GET /report/drops/:userid/:resource_id/:report_type/latest?org_id=
e.g. [https://prod.piper-service.twitch.a2z.com/report/drops/428793187/768c6dac-340e-4e8e-ab01-dc17a9bf9865/campaigns_overview/latest?org_id=d32de13d-937e-4196-8198-1a7f875f295a](https://prod.piper-service.twitch.a2z.com/report/drops/428793187/768c6dac-340e-4e8e-ab01-dc17a9bf9865/campaigns_overview/latest?org_id=d32de13d-937e-4196-8198-1a7f875f295a)


    {
        "url": "https://twitch-piper-reports.s3.us-west-2.amazonaws.com/dynamic/768c6dac-340e-4e8e-ab01-dc17a9bf9865_campaigns_overview_2020-04-14_2020-07-22_720e9d40-e5c1-42c8-8502-5f537fc227b3.csv?X-Amz-Algorithm=***X-Amz-Credential=***&X-Amz-Date=***&X-Amz-Expires=***&X-Amz-Security-Token=***&X-Amz-SignedHeaders=host&response-content-disposition=attachment%3Bfilename%3D%22768c6dac-340e-4e8e-ab01-dc17a9bf9865_campaigns_overview_2020-04-14_2020-07-22.csv%22&X-Amz-Signature=***"
    }

Retrieves a download URL for the most recent report of a given drop campaign and report type.


### GET /helix/report/games/:userid?game_id=&type=&offset=&limit=&start_date=&end_date=

e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/games/279539145&game_id=488552&type=overview_v1?offset=1&limit=1&start_date=2018-03-01T00:00:00Z&end_date=2018-04-01T00:00:00Z](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/games/279539145&game_id=488552&type=overview_v1?offset=1&limit=1&start_date=2018-03-01T00:00:00Z&end_date=2018-04-01T00:00:00Z)

    {
        "data": [
            {
                "game_id": "488552",
                "type": "overview_v1",
                "url": "http://twitch-piper-reports.s3-us-west-2.amazonaws.com/dynamic/game1_overview_v1_2018-03-01_2018-04-01.csvZ?AWSAccessKeyId=***&Expires=1499898667&Signature=***",
                "start_date": "2018-02-21",
                "end_date": "2018-06-01",
            },
            ...
        ],
        "pagination": {
                "offset": 2,
                "limit": 1
        }
    }

Retrieves information and download URLs for all reports the user has access to.  `game_id` and `type` are all optional parameters that can be used to
  filter results from the endpoint.  The included instance and URL are for the latest report of the game/type.  Start and end dates indicate the bounds of the data contained in the downloadable report.

This endpoint supports pagination feature, we are using `offset` and `limit` design for pagination choices. 

- Offset means how many records we skip, usually we start with 0, which means we start from the first record and skip nothing. 
- Limit means how many records we want the endpoints to return. Default is 100 if you don't pass anything. We'll always return to the end if your offset+limit is beyond all records we have.

Invalid limit or offset will throw you error indicating bad request.

When there is no next page, which means your limit+offset reaches the end of our array, we'll return `"pagination": null` indicating EOF. But if there are next page available, there will be a pagination object indicating the next offset and limit you need to pass in your request to us.
For example:

    "pagination": {
        "offset": 2,
        "limit": 1
    }
    
A full sample pagination request would be `http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/helix/report/games/131180913?offset=1&limit=1`.

### GET /helix/report/extensions/:userid?extension_id=&type=&report=

e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/extensions/279539145&extension_id=kr7m1hz7esldlrptruk0fd76l6yq36&type=overview_v1](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/extensions/279539145&extension_id=kr7m1hz7esldlrptruk0fd76l6yq36&type=overview_v1)

    {
        "data": [
            {
                "id": "488552",
                "type": "overview_v1",
                "url": "http://twitch-piper-reports.s3-us-west-2.amazonaws.com/extensions/kr7m1hz7esldlrptruk0fd76l6yq36/default/20170712T000113Z?AWSAccessKeyId=***&Expires=1499898667&Signature=***",
                "start_date": "2018-02-21",
                "end_date": "2018-06-01"
            },
            ...
        ]
    }

Retrieves information and download URLs for all reports the user has access to.  `extension_id` and `type` are all optional parameters that can be used to filter results from the endpoint.  The included instance and URL are for the latest report of the extension/type.  Start and end dates indicate the bounds of the data contained in the downloadable report.

This endpoint supports pagination feature, we are using `offset` and `limit` design for pagination choices. 

- Offset means how many records we skip, usually we start with 0, which means we start from the first record and skip nothing. 
- Limit means how many records we want the endpoints to return. Default is 100 if you don't pass anything. We'll always return to the end if your offset+limit is beyond all records we have.

Invalid limit or offset will throw you error indicating bad request.

When there is no next page, which means your limit+offset reaches the end of our array, we'll return `"pagination": null` indicating EOF. But if there are next page available, there will be a pagination object indicating the next offset and limit you need to pass in your request to us.
For example:

    "pagination": {
        "offset": 2,
        "limit": 1
    }
    
A full sample pagination request would be `http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/helix/report/extensions/15185913?limit=2&offset=1`.

### GET /boxart/upload/:userid/:game

e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/boxart/upload/155668964/498302](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/boxart/upload/155668964/498302)

    {
        "upload": {
            "upload_id": "290e26eb-6710-4fe6-a290-546c97b77b10",
            "url": "https://staging-web-upload-service-ingest.s3-accelerate.amazonaws.com/290e26eb-6710-4fe6-a290-546c97b77b10?X-Amz-Algorithm=***=UNSIGNED-PAYLOAD&X-Amz-Credential=***&X-Amz-Date=***Z&X-Amz-Expires=***X-Amz-SignedHeaders=host&X-Amz-Signature=***"
        }
    }

Retrieves a pre signed URL created by Generic Upload Service for dev portal to upload an image to.

### GET /onepager/games/:user_id/:game_id

e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/onepager/games/131180913/498302](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/onepager/games/131180913/498302)

Retrieve one set of game insights data for one pager feature.

### GET /onepager/games/:user_id/:game_id/quarterstartrange?default=

e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/onepager/games/131180913/498302/quarterstartrange](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/onepager/games/131180913/49830/quarterstartrange)

    {
        "max_quarter": "2",
        "max_year": "2018",
        "min_quarter": "4",
        "min_year": "2017"
    }

Retrieve year and quarter for first and last quarters.

This endpoint features an option to retrieve the default quarter start values 

- `default` means when set to true, the end point will return default year and quarter for the first and last quarters

### GET /report/mods/:user_id
e.g. [http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/mods/155668964](http://prod-insights-piper-service-server.pf7sb7u6kb.us-west-2.elasticbeanstalk.com/report/mods/155668964)

    {
        "reports": [
            {
                "id": "3358",
                "report_type": "overview_v1"
            }
        ]
    }

Retrieve a list of mod reports for a user.

### GET /report/mods/:user_id/:mod_id/:report_type/latest
e.g. [http://localhost:8000/report/mods/25410421/14502/overview_v1/latest](http://localhost:8000/report/mods/25410421/14502/overview_v1/latest)

    {
        "url": "https://twitch-piper-reports-dev.s3-us-west-2.amazonaws.com/dynamic/Postal_overview_v1_2018-10-15_2018-10-23_32612242-9e34-4f33-962a-a9717e9c5210.csv?X-Amz-Algorithm=AWS4-HMAC-SHA256&X-Amz-Credential=AKIAJXRAUMEXYMWR7K5A%2F20181102%2Fus-west-2%2Fs3%2Faws4_request&X-Amz-Date=20181102T200656Z&X-Amz-Expires=300&X-Amz-SignedHeaders=host&response-content-disposition=attachment%3Bfilename%3D%22Postal_overview_v1_2018-10-15_2018-10-23_32612242-9e34-4f33-962a-a9717e9c5210.csv%22&X-Amz-Signature=a8120098520a0ba68c682fc04f2a63016a9ccce452ce23fe3dd5f919bd4b8ee6"
    }

Retrieve a download URL for the latest report.
