# Piper-Service On Call Runbook

## On Call Preparation

 * General Preparation: https://wiki.twitch.com/display/DS/Oncall+Preparation
 * AWS accounts: `twitch-service-piper-dev` and `twitch-service-piper-aws`
 * Slack channel: `#insights-alerts`

### Piper-Service Failures

Consider the following data sources:

 * The [piper-service grafana](https://grafana.internal.justin.tv/d/000001272/insights-piper-service?orgId=1&from=now-7d&to=now-1m) contains recent statistics, endpoint calls, and status codes.
 * The [piper-service rollbar](https://rollbar.com/Twitch/Piper-Service/) contains recent failures and the best location for piper-service failure stack traces.
 * Retrieve your front page OAuth token.
   * Visit http://www.twitch.tv/ under your staff user, with the chrome inspector open
   * In the Network tab, locate a `gql` request with an `Authorization` request header.
   * Copy the contents of that header, and the contents of the `Client-Id` header.
 * Use [Postman](https://www.getpostman.com/apps) or another HTTP request generator to interact with the service directly at one or more of the following locations:
   * Digital extremes report list in staging - https://piper-service.staging.internal.justin.tv/report/games/43376807
   * Digital Extremes report list in production - https://piper-service.production.internal.justin.tv/report/games/43376807
   * Your personal report list in production, via visage: https://api.twitch.tv/v5/piper/report/games/
     * Be sure to include your `Authorization` and `Client-Id` request headers, retrieved earlier.
