package elasticache

import (
	"code.justin.tv/chat/rediczar/poolmetrics"
	"code.justin.tv/chat/rediczar/poolmetrics/statsdpoolmetrics"
	"code.justin.tv/chat/rediczar/redefault"
	"code.justin.tv/insights/piper-service/backend"
	piperconfig "code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/internal/metrics"
	"github.com/sirupsen/logrus"

	"time"

	"code.justin.tv/chat/rediczar"
)

type CacherImpl struct {
	redis             rediczar.ThickClient
	defaultExpiration time.Duration
}

func NewRedisClient(conf piperconfig.PiperConfig, redisCfg piperconfig.RedisDefaultConfig) (backend.Cacher, error) {

	opts := &redefault.ClusterOpts{
		PoolSize:     redisCfg.MaxConnections,
		ReadTimeout:  time.Duration(redisCfg.ReadTimeout) * time.Second,
		WriteTimeout: time.Duration(redisCfg.WriteTimeout) * time.Second,
	}

	client := redefault.NewClusterClient(conf.RedisClusterAddr, opts)

	p := poolmetrics.Collector{
		Client: client,
		StatTracker: &statsdpoolmetrics.StatTracker{
			Stats: metrics.GetTelemetryStatter(),
		},
	}

	if err := p.Setup(); err != nil {
		return nil, err
	}

	// Start collecting pool metrics
	go func() {
		err := p.Start()
		if err != nil {
			logrus.Error("error starting pool metrics", err)

		}
	}()

	return &CacherImpl{
		redis: &rediczar.Client{
			Commands: &rediczar.PrefixedCommands{
				KeyPrefix: "piper-service",
				Redis:     client,
			},
		},
		defaultExpiration: time.Duration(redisCfg.DefaultExpiration) * time.Second,
	}, nil
}
