package elasticache

import (
	"encoding/json"

	"fmt"

	"code.justin.tv/chat/golibs/logx"
	"code.justin.tv/insights/piper-service/models"
	"github.com/go-redis/redis"
	"golang.org/x/net/context"
)

// CacheProperties caches value for userID
func (c *CacherImpl) CacheProperties(ctx context.Context, userID string, prop interface{}) error {
	val, err := json.Marshal(prop)
	if err != nil {
		return err
	}

	if _, err := c.redis.SetNX(ctx, userID, string(val), c.defaultExpiration); err != nil {
		return err
	}

	return nil
}

// GetProperties pulls out value if key exists
func (c *CacherImpl) GetProperties(ctx context.Context, userID string) (interface{}, bool) {
	var item models.GameItem

	val, err := c.redis.Get(ctx, userID)
	if err == redis.Nil {
		return val, false
	} else if err != nil {
		logx.Error(ctx, fmt.Sprintf("Couldn't get value from redis: %v", err))
		return val, false
	} else if err = json.Unmarshal([]byte(val), &item); err != nil {
		logx.Error(ctx, fmt.Sprintf("Couldn't Unmarshal value: %v", err))
		return val, false
	}

	return item, true
}

// CacheHelixReportDates caches report default dates key value pair for helix report
// <userid:gameid:reporttype>_<start_date:end_date>
func (c *CacherImpl) CacheStringProperties(ctx context.Context, key string, prop string) error {
	if _, err := c.redis.SetNX(ctx, key, prop, c.defaultExpiration); err != nil {
		return err
	}

	return nil
}

func (c *CacherImpl) GetStringProperties(ctx context.Context, key string) (string, bool) {
	val, err := c.redis.Get(ctx, key)
	if err == redis.Nil {
		return val, false
	} else if err != nil {
		logx.Error(ctx, fmt.Sprintf("Couldn't get value from redis: %v", err))
		return val, false
	}
	return val, true
}
