package discovery

import (
	"code.justin.tv/insights/piper-service/backend"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

// CachedClient wraps a Client with caching
type CachedClient struct {
	Wrapped Client
	Cacher  backend.Cacher
}

// GetGameNameByGameID is cached
func (c *CachedClient) GetGameNameByID(ctx context.Context, id string) (string, error) {
	key := "gid_" + id

	prop, found := c.Cacher.GetStringProperties(ctx, key)
	if found {
		return prop, nil
	}

	gameName, err := c.Wrapped.GetGameNameByID(ctx, id)
	if err != nil {
		return gameName, err
	}

	err = c.Cacher.CacheStringProperties(ctx, key, gameName)
	return gameName, err
}

// GetGameByID is not cached
func (c *CachedClient) GetGameByID(ctx context.Context, id string) (models.TopGame, error) {
	return c.Wrapped.GetGameByID(ctx, id)
}
