package elerium

import (
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/insights/piper-service/backend"
	piperconfig "code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

type Client interface {
	GetModsByUserID(ctx context.Context, userID string, config piperconfig.PiperConfig) (*[]models.Mod, error)
	GetModsFromClient(ctx context.Context, userID string, config piperconfig.PiperConfig) ([]models.Mod, error)
}

type clientImpl struct {
	twitchclient.Client
	backend.Cacher
}

func NewEleriumClient(conf twitchclient.ClientConf, cacher backend.Cacher) (Client, error) {
	client, err := twitchclient.NewClient(conf)
	if err != nil {
		return nil, err
	}
	return &clientImpl{client, cacher}, nil
}
