package elerium

import (
	"encoding/json"
	"testing"

	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/insights/piper-service/backend/mocks"
	eleriumMocks "code.justin.tv/insights/piper-service/internal/clients/elerium/mocks"
	piperconfig "code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/models"
	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"github.com/stretchr/testify/suite"
	"golang.org/x/net/context"
)

const (
	mockUserID = "123"
)

type getSuite struct {
	suite.Suite
	mockElerium *eleriumMocks.Client
	mockCacher  *mocks.Cacher
	client      Client

	piperConfig piperconfig.PiperConfig
	ctx         context.Context
}

func (suite *getSuite) SetupTest() {
	var err error

	suite.mockElerium = &eleriumMocks.Client{}
	suite.mockCacher = &mocks.Cacher{}
	suite.client, err = NewEleriumClient(twitchclient.ClientConf{Host: "mock"}, suite.mockCacher)
	suite.Require().NoError(err)
}

func (suite *getSuite) TearDownTest() {
	suite.mockElerium.AssertExpectations(suite.T())
}

func (suite *getSuite) TestGetModsFromCache() {
	key := modsKeyPrefix + mockUserID

	modResp := make([]models.Mod, 2)
	modResp = append(modResp, models.Mod{Id: 111, Name: "test mod no.1"})
	modResp = append(modResp, models.Mod{Id: 222, Name: "test mod no.2"})
	modJSON, err := json.Marshal(modResp)

	suite.mockCacher.On("GetStringProperties", suite.ctx, key).Return(string(modJSON), true)
	result, err := suite.client.GetModsByUserID(suite.ctx, mockUserID, suite.piperConfig)
	assert.NoError(suite.T(), err)
	require.Equal(suite.T(), &modResp, result)
}

func TestUtilsSuite(t *testing.T) {
	suite.Run(t, new(getSuite))
}
