package ems

import (
	"code.justin.tv/foundation/twitchclient"
	ems "code.justin.tv/gds/gds/extensions/ems/client"
	"code.justin.tv/insights/piper-service/models"
	"golang.org/x/net/context"
)

//go:generate mockery -name Client
type Client interface {
	GetReleasedExtensionByID(ctx context.Context, id string) (models.ExtensionStats, error)
}

type clientImpl struct {
	ems.Client
}

func NewEMSClient(conf twitchclient.ClientConf) (Client, error) {
	client, err := ems.NewClient(conf)
	if err != nil {
		return nil, err
	}
	return &clientImpl{client}, err
}
