package ems

import (
	"code.justin.tv/foundation/twitchclient"
	"code.justin.tv/gds/gds/extensions/ems/protocol"
	"code.justin.tv/insights/piper-service/models"
	"github.com/afex/hystrix-go/hystrix"
	"golang.org/x/net/context"
)

const extensionBaseURL = "https://www.twitch.tv/ext/"

func init() {
	hystrix.Configure(map[string]hystrix.CommandConfig{
		"get_released_extension_by_id": {
			Timeout:               1000,
			MaxConcurrentRequests: 10000,
		},
	})
}

func (c *clientImpl) GetReleasedExtensionByID(ctx context.Context, id string) (models.ExtensionStats, error) {
	extensionStats := models.ExtensionStats{Id: id}
	hystrixErr := hystrix.Do("get_released_extension_by_id", func() error {
		releasedExt, err := c.Client.GetReleasedExtensionByID(ctx, id, nil)
		if err != nil {
			if clientErr, ok := err.(*twitchclient.Error); ok {
				if clientErr.StatusCode >= 500 {
					return err
				} else {
					return models.ErrResourceNotFound
				}
			}
			return err
		} else if releasedExt == nil {
			return models.ErrResourceNotFound
		} else {
			extensionStats.Url = extensionBaseURL + releasedExt.ID + "-" + releasedExt.Version
		}

		extensionStats.Name = releasedExt.Name
		extensionStats.Description = releasedExt.Description

		if val, ok := releasedExt.IconURLs[protocol.Square100Icon]; ok {
			extensionStats.IconURL = &val
		}

		if val, ok := releasedExt.IconURLs[protocol.DiscoverySplashIcon]; ok {
			extensionStats.SplashURL = &val
		}

		return nil
	}, nil)

	return extensionStats, hystrixErr
}
