package owl

import (
	"context"

	"code.justin.tv/foundation/twitchclient"
	owl "code.justin.tv/web/owl/client"
	"code.justin.tv/web/owl/oauth2"
)

//go:generate mockery -name Client
type Client interface {
	IsClientIDUserMatching(ctx context.Context, userID string, clientID string) (bool, error)
	GetExtensionName(ctx context.Context, clientID string) string
	GetExtensionsByUserID(ctx context.Context, userID string) ([]string, error)
	IsValidExtension(ctx context.Context, extensionID string) error
}

//go:generate mockery -name OwlClient
type OwlClient interface {
	GetClient(ctx context.Context, clientID string, reqOpts *twitchclient.ReqOpts) (*oauth2.Client, error)
	GetClients(ctx context.Context, cursor string, showHidden bool, isExtension bool, filters map[owl.FilterableColumn]string, sKey owl.SortKey, sOrder owl.SortOrder, reqOpts *twitchclient.ReqOpts) ([]*oauth2.Client, string, error)
}

type clientImpl struct {
	owl OwlClient
}

func NewOwlClient(conf twitchclient.ClientConf) (Client, error) {
	client, err := owl.NewClient(conf)
	if err != nil {
		return nil, err
	}
	return &clientImpl{owl: client}, err
}
