package piperdb

import (
	"strconv"

	"time"

	"code.justin.tv/chat/db"
	"code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/insights/piper-service/models"
	_ "github.com/lib/pq"
	"golang.org/x/net/context"
)

//go:generate mockery -name Client
type Client interface {
	GetGameOnePagerByQuarterAndYear(ctx context.Context, gameID string, startTime time.Time) (models.OnePagerData, error)
	GetGameDefaultOnePagerByQuarterAndYear(ctx context.Context, startTime time.Time) (models.OnePagerDefaultData, error)
	GetGameReportByDate(ctx context.Context, gameName string, reportType, startDate, endDate string) ([][]string, error)
	GetExtensionReportByDate(ctx context.Context, extensionID, reportType, startDate, endDate string) ([][]string, error)
	GetQuarterStartByYearQuarter(ctx context.Context, year, quarter string) (time.Time, error)
	GetQuarterStartRange(ctx context.Context, gameID string) (models.QuarterStartRange, error)
	GetDefaultQuarterStartRange(ctx context.Context) (models.QuarterStartRange, error)
	GetModReportByDate(ctx context.Context, modID, reportType, startDate, endDate string) ([][]string, error)
	GetModName(ctx context.Context, modID string) (string, error)
	GetAvailableDomainsWithReports(ctx context.Context, domain string, reportType string, domainIDs []string) ([]string, error)
	GetDomainReportDateRange(ctx context.Context, domain, reportType, domainID string) (time.Time, time.Time, error)
	GetDropsReportByDate(ctx context.Context, resourceID, reportType, startDate, endDate string) ([][]string, error)
}

type clientImpl struct {
	db db.DB
}

type Row interface {
	Scan(dest ...interface{}) error
}

func NewPiperDB(conf config.PiperDBConn, dbOpts config.DBDefaultConfig) (Client, error) {
	port, err := strconv.Atoi(conf.PiperDBReaderPort)
	if err != nil {
		return nil, err
	}

	piperDB, err := db.Open(
		db.DriverName(conf.PiperDBDriver),
		db.Host(conf.PiperDBReaderHost),
		db.Port(port),
		db.User(conf.PiperDBReaderUser),
		db.Password(conf.PiperDBReaderPassword),
		db.DBName(conf.PiperDBReaderDB),
		db.MaxOpenConns(dbOpts.MaxOpenConns),
		db.MaxIdleConns(dbOpts.MaxIdleConns),
		db.MaxQueueSize(dbOpts.MaxQueueSize),
		db.ConnAcquireTimeout(dbOpts.ConnAcquireTimeout),
		db.RequestTimeout(dbOpts.RequestTimeout),
		db.MaxConnAge(dbOpts.MaxConnAge),
	)

	if err != nil {
		panic(err)
	}

	return &clientImpl{piperDB}, nil
}
