package piperdb

import (
	"time"

	"database/sql"

	"github.com/lib/pq"
)

type GamesOverviewV1Report struct {
	Date                time.Time
	Game                string
	Live_views          int
	Non_live_views      int
	Live_uniques        int
	Non_live_uniques    int
	Live_hours          float64
	Non_live_hours      float64
	Unique_broadcasters int
	Hours_broadcast     float64
}

type ExtensionsOverviewV1Report struct {
	Date                   time.Time
	Extension_name         sql.NullString
	Extension_client_id    string
	Installs               int
	Uninstalls             int
	Activations            int
	Unique_active_channels int
	Renders                int
	Unique_renderers       int
	Views                  int
	Unique_viewers         int
	Unique_interactors     int
	Clicks                 int
	Clicks_per_interactor  float64
	Interaction_rate       float64
}

type ExtensionsOverviewV2Report struct {
	Date                                 time.Time
	Extension_name                       sql.NullString
	Extension_client_id                  string
	Extension_details_page_visits        int
	Unique_extension_details_page_visits int
	Installs                             int
	Uninstalls                           int
	Activations                          int
	Unique_active_channels               int
	Unique_active_channels_last_7_days   int
	Unique_active_channels_last_30_days  int
	Unique_identity_links                int
	Unique_identity_unlinks              int
	Renders                              int
	Unique_renderers                     int
	Unique_renderers_last_7_days         int
	Unique_renderers_last_30_days        int
	Views                                int
	Unique_viewers                       int
	Unique_viewers_last_7_days           int
	Unique_viewers_last_30_days          int
	Mouseenters                          int
	Unique_mouseenters                   int
	Unique_mouseenters_last_7_days       int
	Unique_mouseenters_last_30_days      int
	Mouseenters_per_viewer               float64
	Mouseenter_rate                      float64
	Clicks                               int
	Unique_interactors                   int
	Unique_interactors_last_7_days       int
	Unique_interactors_last_30_days      int
	Clicks_per_interactor                float64
	Interaction_rate                     float64
	Minimizations                        int
	Unique_minimizers                    int
	Minimization_rate                    float64
	Unminimizations                      int
	Unique_unminimizers                  int
	Unminimization_rate                  float64
	Bits_revenue_usd                     float64
	Bits_used                            int
	Bits_transactions                    int
	Bits_per_transaction                 float64
	Unique_bits_users                    int
	Unique_bits_users_last_7_days        int
	Unique_bits_users_last_30_days       int
	Bits_used_per_user                   float64
}

type GamesOverviewV2Report struct {
	Date                                  time.Time
	Game                                  string
	GameID                                int
	Total_views                           int
	Live_views                            int
	Non_live_views                        int
	Total_unique_viewers                  int
	Live_uniques                          int
	Non_live_uniques                      int
	Average_concurrent_viewers            int
	Peak_concurrent_viewers               int
	Peak_time_concurrent_viewers          string
	Total_hours_watched                   float64
	Live_hours_watched                    float64
	Non_live_hours_watched                float64
	Unique_broadcasters                   int
	Hours_broadcast                       float64
	Average_concurrent_broadcasters       int
	Peak_concurrent_broadcasters          int
	Peak_time_concurrent_broadcasters     string
	Live_unique_chat_participants         int
	Total_live_chat_messages_sent         int
	Unique_active_channels_with_extension int
	Unique_active_extensions              int
	Clips_created                         int
	Clips_views                           int
	Top_clip_url                          sql.NullString
	Top_clip_url_embed                    sql.NullString
}

type ReportDateRange struct {
	StartDate pq.NullTime
	EndDate   pq.NullTime
}

type ModsOverviewV1Report struct {
	Date                       time.Time
	ModID                      int
	Name                       string
	Points                     float64
	Historical_Download        int
	Daily_Download             int
	Daily_Unique_Download      int
	Daily_Twitch_App_Download  int
	Daily_Curse_Forge_Download int
}

type DomainDateRange struct {
	DomainID  string
	StartDate time.Time
	EndDate   time.Time
}

type DropsCampaignsOverviewReport struct {
	Date                              time.Time
	CampaignID                        string
	CampaignName                      string
	GameID                            string
	GameName                          string
	StreamersEligible                 int
	ViewersEligible                   int
	EventDropsEarned                  int
	MWDropsEarned                     int
	ViewersClaimed                    int
	ViewersLinkedAndClaimed           int
	StreamersEligibleCumulative       int
	ViewersEligibleCumulative         int
	EventDropsEarnedCumulative        int
	MWDropsEarnedCumulative           int
	ViewersClaimedCumulative          int
	ViewersLinkedAndClaimedCumulative int
}

type DropsCampaignsDropsOverviewReport struct {
	Date                    time.Time
	CampaignID              string
	CampaignName            string
	DropID                  string
	DropName                string
	GameID                  string
	GameName                string
	StreamersEligible       int
	EventDropsEarned        int
	MWDropsEarned           int
	ViewersClaimed          int
	ViewersLinkedAndClaimed int
}

type DropsCampaignsTopStreamersReport struct {
	Date                    time.Time
	CampaignID              string
	CampaignName            string
	Channel                 string
	ViewersEligible         int
	EventDropsEarned        int
	MWDropsEarned           int
	ViewersClaimed          int
	ViewersLinkedAndClaimed int
}
