package rbac

import (
	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"code.justin.tv/foundation/twitchclient"
	"golang.org/x/net/context"
)

//go:generate mockery -name Client
type Client interface {
	Validate(ctx context.Context, params *rbacrpc.ValidateQuery) error
	GetCompanyByUserID(ctx context.Context, userID string) (rbacrpc.Company, error)
	GetGameIDsByUserID(ctx context.Context, userID string) ([]string, error)
}

type RBACClient interface {
	ValidateByTwitchID(ctx context.Context, query *rbacrpc.ValidateQuery) (*rbacrpc.ValidateResponse, error)
	GetCompanyByTwitchID(ctx context.Context, id rbacrpc.Id) (*rbacrpc.Company, error)
	GetGamesByTwitchID(ctx context.Context, id rbacrpc.Id) (*rbacrpc.GetGamesByTwitchIDResponse, error)
}

type clientImpl struct {
	rbac rbacrpc.RBAC
}

func NewRBACClient(conf twitchclient.ClientConf) Client {
	rbacrpcClient := rbacrpc.NewRBACProtobufClient(conf.Host, twitchclient.NewHTTPClient(conf))
	return &clientImpl{rbacrpcClient}
}
