package rbac

import (
	"strconv"

	"code.justin.tv/devrel/devsite-rbac/rpc/rbacrpc"
	"code.justin.tv/insights/piper-service/models"
	"github.com/afex/hystrix-go/hystrix"
	"github.com/twitchtv/twirp"
	"golang.org/x/net/context"
)

func init() {
	hystrix.Configure(map[string]hystrix.CommandConfig{
		"get_company_by_twitch_id": {
			Timeout:               1000,
			MaxConcurrentRequests: 10000,
		},
		"get_game_ids_by_twitch_id": {
			Timeout:               1000,
			MaxConcurrentRequests: 10000,
		},
	})
}

func (c *clientImpl) GetGameIDsByUserID(ctx context.Context, userID string) ([]string, error) {
	var gameIDs []string
	var games []*rbacrpc.Game
	hystrixErr := hystrix.Do("get_game_ids_by_twitch_id", func() error {
		getGamesByTwitchIDResp, err := c.rbac.GetGamesByTwitchID(ctx, &rbacrpc.Id{Id: userID})
		if twerr, ok := err.(twirp.Error); ok {
			if twerr.Code() == twirp.NotFound {
				return models.ErrUserNoGames
			}
		}

		if getGamesByTwitchIDResp == nil || (*getGamesByTwitchIDResp).XTotal == 0 || len((*getGamesByTwitchIDResp).Games) == 0 {
			return models.ErrUserNoGames
		}

		games = (*getGamesByTwitchIDResp).Games

		return nil
	}, nil)

	if hystrixErr != nil {
		return nil, hystrixErr
	}

	for _, game := range games {
		if game != nil {
			gameIDs = append(gameIDs, strconv.Itoa(int(game.Id)))
		}
	}

	return gameIDs, nil
}

func (c *clientImpl) GetCompanyByUserID(ctx context.Context, userID string) (rbacrpc.Company, error) {
	company := rbacrpc.Company{}
	hystrixErr := hystrix.Do("get_company_by_twitch_id", func() error {
		companyByUserResp, err := c.rbac.GetCompanyByTwitchID(ctx, &rbacrpc.Id{Id: userID})
		if twerr, ok := err.(twirp.Error); ok {
			if twerr.Code() == twirp.NotFound {
				return models.ErrUserNoCompany
			}
		}

		if companyByUserResp == nil {
			return models.ErrUserNoCompany
		}

		company = *companyByUserResp
		return nil
	}, nil)
	return company, hystrixErr
}
