package sandstorm

import (
	"context"
	"fmt"
	"time"

	"github.com/sirupsen/logrus"

	"code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/systems/sandstorm/manager"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/aws/aws-sdk-go/aws/credentials/stscreds"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sts"
)

type Client interface {
	GetSecret(ctx context.Context, secretPath string) (*manager.Secret, error)
}

type clientImpl struct {
	client *manager.Manager
}

func New(conf config.PiperConfig) Client {
	awsConfig := &aws.Config{Region: &conf.AWSRegion}
	stsClient := sts.New(session.New(awsConfig))

	callerIdentity, err := stsClient.GetCallerIdentity(&sts.GetCallerIdentityInput{})
	if err != nil {
		fmt.Println("caller identity error:", err)
	}
	if err == nil {
		fmt.Printf("using caller identity: %s\n", callerIdentity)
	}

	creds := credentials.NewCredentials(&stscreds.AssumeRoleProvider{
		Duration:     900 * time.Second,
		ExpiryWindow: 10 * time.Second,
		RoleARN:      conf.SandStormRoleARN,
		Client:       stsClient,
	})
	awsConfig.WithCredentials(creds)

	return &clientImpl{manager.New(manager.Config{
		AWSConfig: awsConfig,
		Logger:    logrus.New(),
	})}
}
