package mocks

import (
	"context"

	mock "github.com/stretchr/testify/mock"

	spade "code.justin.tv/common/spade-client-go/spade"
)

// Client is an autogenerated mock type for the Client type
type Client struct {
	mock.Mock
}

// TrackEvent provides a mock function with given fields: ctx, event, properties
func (_m *Client) TrackEvent(ctx context.Context, event string, properties interface{}) error {
	ret := _m.Called(ctx, event, properties)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, string, interface{}) error); ok {
		r0 = rf(ctx, event, properties)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

// TrackEvents provides a mock function with given fields: ctx, events
func (_m *Client) TrackEvents(ctx context.Context, events ...spade.Event) error {
	ret := _m.Called(ctx, events)

	var r0 error
	if rf, ok := ret.Get(0).(func(context.Context, ...spade.Event) error); ok {
		r0 = rf(ctx, events...)
	} else {
		r0 = ret.Error(0)
	}

	return r0
}

var _ spade.Client = (*Client)(nil)
