package uploader

import (
	"code.justin.tv/foundation/twitchclient"
	piperconfig "code.justin.tv/insights/piper-service/internal/config"
	"code.justin.tv/web/upload-service/rpc/uploader"
	"golang.org/x/net/context"
)

type Client interface {
	CreateUploadServiceRequest(ctx context.Context, id, name string, conf piperconfig.PiperConfig) (*uploader.UploadResponse, error)
}

type uploaderImpl struct {
	uploaderClient uploader.Uploader
	callbackSNSArn string
}

func NewUploader(conf piperconfig.PiperConfig) Client {
	httpClient := twitchclient.NewHTTPClient(twitchclient.ClientConf{})
	uploaderClient := uploader.NewUploaderProtobufClient(conf.UploadURL, httpClient)

	return &uploaderImpl{uploaderClient, conf.UploadCallbackSNSArn}
}
