package users

import (
	"context"

	"code.justin.tv/foundation/twitchclient"
	userservice "code.justin.tv/web/users-service/client/usersclient_internal"
)

//go:generate mockery -name Client
type Client interface {
	IsStaff(context context.Context, userID string) (bool, error)
	GetUserImage(ctx context.Context, login string) string
}

type clientImpl struct {
	userservice.InternalClient
}

func NewUserClient(conf twitchclient.ClientConf) (Client, error) {
	client, err := userservice.NewClient(conf)
	if err != nil {
		return nil, err
	}
	return &clientImpl{client}, err
}
