package users

import (
	"context"
	"fmt"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	"code.justin.tv/insights/piper-service/internal/metrics"
)

const defaultPicture = "https://static-cdn.jtvnw.net/user-default-pictures/49988c7b-57bc-4dee-bd4f-6df4ad215d3a-profile_image-150x150.jpg"

func (c *clientImpl) IsStaff(ctx context.Context, userID string) (bool, error) {
	props, err := c.GetUserByID(ctx, userID, nil)
	if props == nil || err != nil {
		metrics.Reporter().Report("users-service.get-user-by-id.failure", 1, telemetry.UnitCount)
		return false, err
	}

	return props.Admin != nil && *props.Admin, nil
}

func (c *clientImpl) GetUserImage(ctx context.Context, login string) string {
	props, err := c.GetUserByLogin(ctx, login, nil)
	if err != nil {
		metrics.Reporter().Report("users-service.get-image.failure", 1, telemetry.UnitCount)
		return defaultPicture
	}
	if props.ProfileImageURL == nil || *props.ProfileImageURL == "" {
		return defaultPicture
	}
	return fmt.Sprintf(*props.ProfileImageURL, "150x150")
}
