package metrics

import (
	"errors"

	telemetry "code.justin.tv/amzn/TwitchTelemetry"
	. "code.justin.tv/insights/piper-service/internal/utils"

	identifier "code.justin.tv/amzn/TwitchProcessIdentifier"
)

var processIdentifier *identifier.ProcessIdentifier
var processIdentifierSet bool
var sampleBuilder *telemetry.SampleBuilder

func initializeProcessIdentifier() error {
	hostname, err := Hostname()
	if err != nil {
		return err
	}

	if processIdentifierSet {
		return errors.New("process identifier already set")
	}
	processIdentifier = &identifier.ProcessIdentifier{
		Service: ServiceName,
		Region:  DefaultAWSRegion,
		Stage:   Environment(),
		Machine: hostname,
	}
	processIdentifierSet = true
	sampleBuilder = &telemetry.SampleBuilder{ProcessIdentifier: *processIdentifier}
	return nil
}

func ProcessIdentifier() *identifier.ProcessIdentifier {
	return processIdentifier
}
