package metrics

import (
	"time"

	. "code.justin.tv/insights/piper-service/internal/utils"

	"code.justin.tv/commerce/splatter"

	"github.com/cactus/go-statsd-client/statsd"
)

var telemetryStatter statsd.Statter

func newCWStater() {
	buffConfig := &splatter.BufferedTelemetryConfig{
		FlushPeriod:       flushPeriod,
		BufferSize:        bufferSize,
		AggregationPeriod: time.Minute,
		ServiceName:       ServiceName,
		AWSRegion:         DefaultAWSRegion,
		Stage:             Environment(),
	}

	telemetryStatter = splatter.NewBufferedTelemetryCloudWatchStatter(buffConfig, map[string]bool{})
}

func GetTelemetryStatter() statsd.Statter {
	return telemetryStatter
}
